/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicySet;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.finder.PolicyFinder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyReader;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class PolicyIndexBase
implements PolicyIndex {
    protected static final String SUBJECT_KEY = "subjectAttributes";
    protected static final String RESOURCE_KEY = "resourceAttributes";
    protected static final String ACTION_KEY = "actionAttributes";
    protected static final String ENVIRONMENT_KEY = "environmentAttributes";
    public boolean indexed = true;
    protected Map<String, Map<String, String>> indexMap = null;
    protected PolicyReader m_policyReader;
    private static final Logger log = LoggerFactory.getLogger((String)PolicyIndexBase.class.getName());
    protected static final String METADATA_POLICY_NS = "metadata";
    public static final Map<String, String> namespaces = new HashMap<String, String>();

    protected PolicyIndexBase(PolicyReader policyReader) throws PolicyIndexException {
        this.m_policyReader = policyReader;
        String[] indexMapElements = new String[]{SUBJECT_KEY, RESOURCE_KEY, ACTION_KEY, ENVIRONMENT_KEY};
        this.indexMap = new HashMap<String, Map<String, String>>();
        for (String s : indexMapElements) {
            this.indexMap.put(s, new HashMap());
        }
    }

    public void setSubjectAttributes(Map<String, String> attributeMap) {
        this.setAttributeMap(SUBJECT_KEY, attributeMap);
    }

    public void setResourceAttributes(Map<String, String> attributeMap) {
        this.setAttributeMap(RESOURCE_KEY, attributeMap);
    }

    public void setActionAttributes(Map<String, String> attributeMap) {
        this.setAttributeMap(ACTION_KEY, attributeMap);
    }

    public void setEnvironmentAttributes(Map<String, String> attributeMap) {
        this.setAttributeMap(ENVIRONMENT_KEY, attributeMap);
    }

    protected void setAttributeMap(String mapKey, Map<String, String> attributeMap) {
        this.indexMap.get(mapKey).putAll(attributeMap);
    }

    protected Map<String, Set<AttributeBean>> getAttributeMap(EvaluationCtx eval) throws URISyntaxException {
        AttributeBean ab;
        String attributeType;
        AttributeValue value;
        Iterator i;
        AttributeValue attr;
        EvaluationResult result;
        URI defaultCategoryURI = new URI("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
        Map<String, String> im = null;
        HashMap<String, Set<AttributeBean>> attributeMap = new HashMap<String, Set<AttributeBean>>();
        HashMap<String, AttributeBean> attributeBeans = null;
        im = this.indexMap.get(SUBJECT_KEY);
        attributeBeans = new HashMap<String, AttributeBean>();
        for (String attributeId : im.keySet()) {
            result = eval.getSubjectAttribute(new URI(im.get(attributeId)), new URI(attributeId), defaultCategoryURI);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put(SUBJECT_KEY, new HashSet(attributeBeans.values()));
        im = this.indexMap.get(RESOURCE_KEY);
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            result = eval.getResourceAttribute(new URI(im.get(attributeId)), new URI(attributeId), null);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                if (attributeId.equals(XACML_RESOURCE_ID) && value.encode().startsWith("/")) {
                    String[] components = PolicyIndexBase.makeComponents(value.encode());
                    if (components != null && components.length > 0) {
                        for (String c : components) {
                            ab.addValue(c);
                        }
                        continue;
                    }
                    ab.addValue(value.encode());
                    continue;
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put(RESOURCE_KEY, new HashSet(attributeBeans.values()));
        im = this.indexMap.get(ACTION_KEY);
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            result = eval.getActionAttribute(new URI(im.get(attributeId)), new URI(attributeId), null);
            if (result.getStatus() != null || result.indeterminate() || !(attr = result.getAttributeValue()).returnsBag() || !(i = ((BagAttribute)attr).iterator()).hasNext()) continue;
            while (i.hasNext()) {
                value = (AttributeValue)i.next();
                attributeType = im.get(attributeId);
                ab = (AttributeBean)attributeBeans.get(attributeId);
                if (ab == null) {
                    ab = new AttributeBean();
                    ab.setId(attributeId);
                    ab.setType(attributeType);
                    attributeBeans.put(attributeId, ab);
                }
                ab.addValue(value.encode());
            }
        }
        attributeMap.put(ACTION_KEY, new HashSet(attributeBeans.values()));
        im = this.indexMap.get(ENVIRONMENT_KEY);
        attributeBeans = new HashMap();
        for (String attributeId : im.keySet()) {
            Iterator i2;
            AttributeValue attr2;
            URI attrId;
            URI imAttrId = new URI(im.get(attributeId));
            EvaluationResult result2 = eval.getEnvironmentAttribute(imAttrId, attrId = new URI(attributeId), null);
            if (result2.getStatus() != null || result2.indeterminate() || !(attr2 = result2.getAttributeValue()).returnsBag() || !(i2 = ((BagAttribute)attr2).iterator()).hasNext()) continue;
            while (i2.hasNext()) {
                AttributeValue value2 = (AttributeValue)i2.next();
                String attributeType2 = im.get(attributeId);
                AttributeBean ab2 = (AttributeBean)attributeBeans.get(attributeId);
                if (ab2 == null) {
                    ab2 = new AttributeBean();
                    ab2.setId(attributeId);
                    ab2.setType(attributeType2);
                    attributeBeans.put(attributeId, ab2);
                }
                ab2.addValue(value2.encode());
            }
        }
        attributeMap.put(ENVIRONMENT_KEY, new HashSet(attributeBeans.values()));
        return attributeMap;
    }

    protected AbstractPolicy handleDocument(Document doc, PolicyFinder policyFinder) throws ParsingException {
        Element root = doc.getDocumentElement();
        String name = root.getTagName();
        if (name.equals("Policy")) {
            return Policy.getInstance((Node)root);
        }
        if (name.equals("PolicySet")) {
            return PolicySet.getInstance((Node)root, (PolicyFinder)policyFinder);
        }
        throw new ParsingException("Unknown root document type: " + name);
    }

    protected static String[] makeComponents(String resourceId) {
        if (resourceId == null || resourceId.equals("") || !resourceId.startsWith("/")) {
            return null;
        }
        ArrayList<String> components = new ArrayList<String>();
        String[] parts = resourceId.split("\\/");
        for (int x = 1; x < parts.length; ++x) {
            StringBuilder sb = new StringBuilder();
            for (int y = 0; y < x; ++y) {
                sb.append("/");
                sb.append(parts[y + 1]);
            }
            components.add(sb.toString());
            if (x != parts.length - 1) {
                components.add(sb.toString() + "/.*");
                continue;
            }
            components.add(sb.toString() + "$");
        }
        return components.toArray(new String[components.size()]);
    }

    static {
        namespaces.put("p", XACML20_POLICY_NS);
        namespaces.put("m", METADATA_POLICY_NS);
    }
}

