/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.fcrepo.server.config.ServerConfiguration;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.utilities.rebuild.Rebuilder;

public class PolicyIndexRebuilder
implements Rebuilder {
    protected PolicyIndex m_policyIndex = null;

    public void addObject(DigitalObject object) throws Exception {
        Iterable policyDatastreams = object.datastreams("FESLPOLICY");
        Date latest = null;
        Datastream policyDatastream = null;
        for (Datastream ds : policyDatastreams) {
            if (latest != null && !ds.DSCreateDT.after(latest)) continue;
            latest = ds.DSCreateDT;
            policyDatastream = ds;
        }
        if (policyDatastream != null) {
            System.out.println("   Adding " + object.getPid() + " to index.");
            String policy = new String(IOUtils.toByteArray((InputStream)policyDatastream.getContentStream()), "UTF-8");
            this.m_policyIndex.addPolicy(object.getPid(), policy);
        }
    }

    public void finish() throws Exception {
    }

    public String getAction() {
        return "Rebuild the FeSL policy cache";
    }

    public boolean shouldStopServer() {
        return true;
    }

    public void start(Map<String, String> options) throws Exception {
        if (!this.m_policyIndex.clear()) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println("NOTE: You must now manually delete (clear) ");
            System.out.println("      the existing database.  This rebuilder was");
            System.out.println("      unable to perform this step. ");
            System.out.println("      Press enter when finished.");
            try {
                reader.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Map<String, String> getOptions() throws Exception {
        return null;
    }

    public void init() {
    }

    public void setPolicyIndex(PolicyIndex policyIndex) {
        this.m_policyIndex = policyIndex;
    }

    public void setServerConfiguration(ServerConfiguration serverConfig) {
    }

    public void setServerDir(File serverBaseDir) {
    }
}

