/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Subject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtil.class);
    private static final URI XACML_RESOURCE_ID = Constants.XACML1_RESOURCE.ID.getURI();
    private final Map<URI, URI> actionMap = new ConcurrentHashMap<URI, URI>();
    private final Map<String, String> actionValueMap = new ConcurrentHashMap<String, String>();

    public ContextUtil() {
        logger.info("created");
    }

    public void setActionMap(Map<String, String> actions) {
        for (String from : actions.keySet()) {
            String to = actions.get(from);
            try {
                URI key = new URI(from);
                URI value = new URI(actions.get(from));
                this.actionMap.put(key, value);
            }
            catch (URISyntaxException e) {
                logger.warn("Mapping contained invalid URI: [" + from + "] / [" + to + "]");
            }
        }
    }

    public void setActionValueMap(Map<String, String> values) {
        this.actionValueMap.putAll(values);
    }

    public Set<Subject> setupSubjects(List<Map<URI, List<AttributeValue>>> subjs) {
        HashSet<Subject> subjects = new HashSet<Subject>();
        if (subjs == null || subjs.size() == 0) {
            subjects.add(new Subject(new HashSet()));
            return subjects;
        }
        for (Map<URI, List<AttributeValue>> s : subjs) {
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            for (URI uri : s.keySet()) {
                List<AttributeValue> attributeValues = s.get(uri);
                for (AttributeValue attributeValue : attributeValues) {
                    attributes.add(new Attribute(uri, null, null, attributeValue));
                }
            }
            subjects.add(new Subject(attributes));
        }
        return subjects;
    }

    public Set<Attribute> setupResources(Map<URI, AttributeValue> res, RelationshipResolver relationshipResolver) throws MelcoeXacmlException {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        if (res == null || res.size() == 0) {
            return attributes;
        }
        try {
            String pid = null;
            AttributeValue pidAttr = res.get(XACML_RESOURCE_ID);
            if (pidAttr != null) {
                pid = pidAttr.encode();
                pid = relationshipResolver.buildRESTParentHierarchy(pid);
                String dsid = null;
                AttributeValue dsidAttr = res.get(Constants.DATASTREAM.ID.getURI());
                if (dsidAttr != null && !(dsid = dsidAttr.encode()).equals("")) {
                    pid = pid + "/" + dsid;
                }
                res.put(XACML_RESOURCE_ID, (AttributeValue)new AnyURIAttribute(new URI(pid)));
            }
        }
        catch (Exception e) {
            logger.error("Error finding parents.", (Throwable)e);
            throw new MelcoeXacmlException("Error finding parents.", e);
        }
        for (URI uri : res.keySet()) {
            attributes.add(new Attribute(uri, null, null, res.get(uri)));
        }
        return attributes;
    }

    public Set<Attribute> setupAction(Map<URI, AttributeValue> a) {
        HashSet<Attribute> actions = new HashSet<Attribute>();
        if (a == null || a.size() == 0) {
            return actions;
        }
        HashMap<URI, AttributeValue> newActions = new HashMap<URI, AttributeValue>();
        for (URI uri : a.keySet()) {
            String tmpValue;
            URI newUri = null;
            AttributeValue newValue = null;
            if (this.actionMap != null && this.actionMap.size() > 0) {
                newUri = this.actionMap.get(uri);
            }
            if (this.actionValueMap != null && this.actionValueMap.size() > 0 && (tmpValue = this.actionValueMap.get(a.get(uri).encode())) != null) {
                newValue = new StringAttribute(tmpValue);
            }
            newUri = newUri == null ? uri : newUri;
            newValue = newValue == null ? a.get(uri) : newValue;
            newActions.put(newUri, newValue);
        }
        for (URI uri : newActions.keySet()) {
            actions.add(new Attribute(uri, null, null, (AttributeValue)newActions.get(uri)));
        }
        return actions;
    }

    public Set<Attribute> setupEnvironment(Map<URI, AttributeValue> e) {
        HashSet<Attribute> environment = new HashSet<Attribute>();
        if (e == null || e.size() == 0) {
            return environment;
        }
        for (URI uri : e.keySet()) {
            environment.add(new Attribute(uri, null, null, e.get(uri)));
        }
        return environment;
    }

    public RequestCtx buildRequest(List<Map<URI, List<AttributeValue>>> subjects, Map<URI, AttributeValue> actions, Map<URI, AttributeValue> resources, Map<URI, AttributeValue> environment, RelationshipResolver relationshipResolver) throws MelcoeXacmlException {
        if (logger.isDebugEnabled()) {
            logger.debug("Building request!");
        }
        RequestCtx request = null;
        try {
            request = new RequestCtx(this.setupSubjects(subjects), this.setupResources(resources, relationshipResolver), this.setupAction(actions), this.setupEnvironment(environment));
        }
        catch (Exception e) {
            logger.error("Error creating request.", (Throwable)e);
            throw new MelcoeXacmlException("Error creating request", e);
        }
        return request;
    }

    public ResponseCtx makeResponseCtx(String response) throws MelcoeXacmlException {
        ResponseCtx resCtx = null;
        try {
            String newResponse = response.replaceAll("ResourceID", "ResourceId");
            ByteArrayInputStream is = new ByteArrayInputStream(newResponse.getBytes());
            resCtx = ResponseCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return resCtx;
    }

    public RequestCtx makeRequestCtx(String request) throws MelcoeXacmlException {
        RequestCtx reqCtx = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
            reqCtx = RequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return reqCtx;
    }

    public String makeRequestCtx(RequestCtx reqCtx) {
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        reqCtx.encode((OutputStream)request, new Indenter());
        return new String(request.toByteArray());
    }

    public String makeResponseCtx(ResponseCtx resCtx) {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        resCtx.encode((OutputStream)response, new Indenter());
        return new String(response.toByteArray());
    }

    public Map<String, Result> makeResultMap(ResponseCtx resCtx) {
        Iterator i = resCtx.getResults().iterator();
        HashMap<String, Result> resultMap = new HashMap<String, Result>();
        while (i.hasNext()) {
            Result r = (Result)i.next();
            resultMap.put(r.getResource(), r);
        }
        return resultMap;
    }
}

