/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.io.File;
import java.io.FileNotFoundException;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.data.AbstractPolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.util.PolicyFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopulatePolicyDatabase {
    private static final Logger logger = LoggerFactory.getLogger(PopulatePolicyDatabase.class);
    private static final String POLICY_HOME = MelcoePDP.PDP_HOME.getAbsolutePath() + "/policies";

    public static void add(PolicyStore policyStore) throws PolicyStoreException, FileNotFoundException {
        logger.info("Starting clock!");
        long time1 = System.nanoTime();
        AbstractPolicyStore.addDocuments((AbstractPolicyStore)policyStore);
        long time2 = System.nanoTime();
        logger.info("Stopping clock!");
        logger.info("Time taken: " + (time2 - time1));
    }

    @Deprecated
    public static synchronized void addDocuments(PolicyStore policyStore) throws PolicyStoreException, FileNotFoundException {
        AbstractPolicyStore.addDocuments((AbstractPolicyStore)policyStore);
    }

    public static File[] getPolicyFiles() {
        File policyHome = new File(POLICY_HOME);
        File[] policies = policyHome.listFiles(new PolicyFileFilter());
        return policies;
    }
}

