/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.policy.xacml1.XACML1PolicyCombiningNamespace;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.TargetMatchGroup;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombinerElement;
import org.jboss.security.xacml.sunxacml.combine.PolicyCombiningAlgorithm;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HierarchicalLowestChildPermitOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(HierarchicalLowestChildPermitOverridesPolicyAlg.class);
    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    public static final String XACML_RESOURCE_ID = Constants.XACML1_RESOURCE.ID.toString();
    public static final String algId = XACML1PolicyCombiningNamespace.getInstance().HIER_LOWEST_PERMIT_OVERRIDES.uri;
    private static final URI identifierURI = XACML1PolicyCombiningNamespace.getInstance().HIER_LOWEST_PERMIT_OVERRIDES.getURI();
    private static RuntimeException earlyException;

    public HierarchicalLowestChildPermitOverridesPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected HierarchicalLowestChildPermitOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    public Result combine(EvaluationCtx context, List parameters, List policyElements) {
        logger.info("Combining using: " + this.getIdentifier());
        boolean atLeastOneError = false;
        boolean atLeastOneDeny = false;
        HashSet denyObligations = new HashSet();
        Status firstIndeterminateStatus = null;
        HashSet<AbstractPolicy> matchedPolicies = new HashSet<AbstractPolicy>();
        Iterator it = policyElements.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = ((PolicyCombinerElement)it.next()).getPolicy();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                atLeastOneError = true;
                if (firstIndeterminateStatus != null) continue;
                firstIndeterminateStatus = match.getStatus();
                continue;
            }
            if (match.getResult() != 0) continue;
            matchedPolicies.add(policy);
        }
        Set<AbstractPolicy> applicablePolicies = this.getApplicablePolicies(context, matchedPolicies);
        for (AbstractPolicy policy : applicablePolicies) {
            Result result = policy.evaluate(context);
            int effect = result.getDecision();
            if (effect == 0) {
                return result;
            }
            if (effect == 1) {
                atLeastOneDeny = true;
                denyObligations.addAll(result.getObligations());
                continue;
            }
            if (effect != 2) continue;
            atLeastOneError = true;
            if (firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (atLeastOneDeny) {
            return new Result(1, context.getResourceId().encode(), denyObligations);
        }
        if (atLeastOneError) {
            return new Result(2, firstIndeterminateStatus, context.getResourceId().encode());
        }
        return new Result(3, context.getResourceId().encode());
    }

    private Set<AbstractPolicy> getApplicablePolicies(EvaluationCtx context, Set<AbstractPolicy> policies) {
        int largest = 0;
        HashSet<Object> applicablePolicies = new HashSet<AbstractPolicy>();
        for (AbstractPolicy policy : policies) {
            String resourceId = "";
            List tmg = policy.getTarget().getResourcesSection().getMatchGroups();
            for (TargetMatchGroup t : tmg) {
                if (t.match(context).getResult() > 0) continue;
                resourceId = this.extractResourceId(t);
                if (resourceId == null) {
                    logger.warn("Policy did not contain resourceId: " + policy.getId());
                    continue;
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("ResourceID: " + resourceId);
            }
            int current = resourceId == null || resourceId.isEmpty() ? 0 : this.getLength(resourceId);
            if (current > largest) {
                largest = current;
                applicablePolicies = new HashSet();
            }
            if (current < largest) continue;
            applicablePolicies.add(policy);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Applicable policies:");
            for (AbstractPolicy p : applicablePolicies) {
                logger.debug("\t" + p.getId());
            }
        }
        return applicablePolicies;
    }

    private String extractResourceId(TargetMatchGroup tmg) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tmg.encode((OutputStream)output, new Indenter(4));
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pe) {
            logger.error("Error obtaining an XML parser: " + pe.getMessage(), (Throwable)pe);
            return null;
        }
        Document doc = null;
        try {
            doc = docBuilder.parse(new ByteArrayInputStream(output.toByteArray()));
        }
        catch (Exception e) {
            logger.error("Problem parsing TargetMatchGroup to obtain id");
            return null;
        }
        String resourceId = null;
        String designator = null;
        String value = null;
        NodeList nodes = doc.getElementsByTagName("ResourceMatch").item(0).getChildNodes();
        for (int x = 0; x < nodes.getLength() && resourceId == null; ++x) {
            Node n = nodes.item(x);
            if (n.getNodeType() != 1) continue;
            if ("AttributeValue".equals(n.getNodeName())) {
                value = n.getFirstChild().getNodeValue();
            } else if ("ResourceAttributeDesignator".equals(n.getNodeName())) {
                designator = n.getAttributes().getNamedItem("AttributeId").getNodeValue();
            }
            if (!XACML_RESOURCE_ID.equals(designator)) continue;
            resourceId = value;
        }
        if (resourceId == null) {
            resourceId = "";
        }
        return resourceId;
    }

    private int getLength(String resourceId) {
        if (resourceId == null || resourceId.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Length: " + resourceId + " " + 0);
            }
            return 0;
        }
        String[] components = resourceId.split("\\/");
        for (int x = 0; x < components.length; ++x) {
            if (!components[x].matches(".*[^\\w\\-\\&\\:\\+\\~\\$]+.*")) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("Length: " + resourceId + " " + (x - 1) + "\tComponent: " + components[x]);
            }
            return x - 1;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Length [return]: " + resourceId + " " + (components.length - 1));
        }
        return components.length - 1;
    }
}

