/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlDocumentConfig;
import com.sleepycat.dbxml.XmlException;
import com.sleepycat.dbxml.XmlQueryContext;
import com.sleepycat.dbxml.XmlQueryExpression;
import com.sleepycat.dbxml.XmlResults;
import com.sleepycat.dbxml.XmlValue;
import java.io.File;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fcrepo.server.security.xacml.pdp.data.DbXmlManager;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyUtils;
import org.fcrepo.server.security.xacml.pdp.data.XPathPolicyIndex;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyReader;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbXmlPolicyIndex
extends XPathPolicyIndex
implements PolicyIndex {
    private static final Logger log = LoggerFactory.getLogger((String)DbXmlPolicyIndex.class.getName());
    private String m_databaseDirectory = null;
    private String m_container = null;
    private DbXmlManager m_dbXmlManager = null;
    private volatile long m_lastUpdate;
    private PolicyUtils m_utils;
    private Map<String, XmlQueryExpression> m_queries = null;

    public DbXmlPolicyIndex(PolicyReader policyReader) throws PolicyIndexException {
        super(policyReader);
    }

    public void setDatabaseDirectory(String databaseDirectory) {
        this.m_databaseDirectory = databaseDirectory;
    }

    public void setContainer(String container) {
        this.m_container = container;
    }

    public void init() throws PolicyIndexException {
        try {
            this.m_dbXmlManager = new DbXmlManager(this.m_databaseDirectory, this.m_container);
            this.m_dbXmlManager.indexMap = this.indexMap;
        }
        catch (PolicyStoreException pse) {
            throw new PolicyIndexException(pse.getMessage(), pse);
        }
        this.m_queries = new ConcurrentHashMap<String, XmlQueryExpression>();
        this.m_utils = new PolicyUtils();
    }

    public void close() {
        this.m_dbXmlManager.close();
        this.m_queries.clear();
    }

    @Override
    public Map<String, AbstractPolicy> getPolicies(EvaluationCtx eval, PolicyFinder policyFinder) throws PolicyIndexException {
        long a = 0L;
        long b = 0L;
        long total = 0L;
        HashMap<String, AbstractPolicy> documents = new HashMap<String, AbstractPolicy>();
        XmlQueryExpression qe = null;
        XmlQueryContext context = null;
        try {
            a = System.nanoTime();
            Map<String, Collection<AttributeBean>> attributeMap = this.getAttributeMap(eval);
            context = this.m_dbXmlManager.manager.createQueryContext();
            context.setDefaultCollection(this.m_dbXmlManager.CONTAINER);
            for (String prefix : namespaces.keySet()) {
                context.setNamespace(prefix, (String)namespaces.get(prefix));
            }
            int resourceComponentCount = 0;
            Map<String, String> variables = DbXmlPolicyIndex.getXpathVariables(attributeMap);
            for (String variable : variables.keySet()) {
                context.setVariableValue(variable, new XmlValue(variables.get(variable)));
                if (!variable.equals(XACML_RESOURCE_ID)) continue;
                ++resourceComponentCount;
            }
            qe = this.getQuery(attributeMap, context, resourceComponentCount);
        }
        catch (XmlException xe) {
            throw new PolicyIndexException("Error while constructing query", xe);
        }
        catch (URISyntaxException e) {
            throw new PolicyIndexException("Error while constructing query", e);
        }
        DbXmlManager.readLock.lock();
        try {
            b = System.nanoTime();
            total += b - a;
            if (log.isDebugEnabled()) {
                log.debug("Query prep. time: " + (b - a) + "ns");
            }
            a = System.nanoTime();
            XmlResults results = qe.execute(context);
            b = System.nanoTime();
            total += b - a;
            if (log.isDebugEnabled()) {
                log.debug("Query exec. time: " + (b - a) + "ns");
            }
            while (results.hasNext()) {
                XmlValue value = results.next();
                byte[] content = value.asDocument().getContent();
                if (content.length > 0) {
                    documents.put(value.asDocument().getName(), this.handleDocument(this.m_policyReader.readPolicy(content), policyFinder));
                    continue;
                }
                throw new PolicyIndexException("Zero-length result found");
            }
            results.delete();
        }
        catch (XmlException xe) {
            log.error("Error getting query results." + xe.getMessage());
            throw new PolicyIndexException("Error getting query results." + xe.getMessage(), xe);
        }
        catch (ParsingException pe) {
            log.error("Error getting query results." + pe.getMessage());
            throw new PolicyIndexException("Error getting query results." + pe.getMessage(), pe);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug("Total exec. time: " + total + "ns");
        }
        return documents;
    }

    private XmlQueryExpression getQuery(Map<String, Collection<AttributeBean>> attributeMap, XmlQueryContext context, int r) throws XmlException {
        StringBuilder sb = new StringBuilder(64 * attributeMap.size());
        for (Collection<AttributeBean> attributeBeans : attributeMap.values()) {
            sb.append(attributeBeans.size() + ":");
            for (AttributeBean bean : attributeBeans) {
                sb.append(bean.getValues().size() + "-");
            }
        }
        String hash = sb.toString() + r;
        XmlQueryExpression result = this.m_queries.get(hash);
        if (result != null) {
            return result;
        }
        String query = this.createQuery(attributeMap);
        if (log.isDebugEnabled()) {
            log.debug("Query [{}]:\n{}", (Object)hash, (Object)query);
        }
        result = this.m_dbXmlManager.manager.prepare(query, context);
        this.m_queries.put(hash, result);
        return result;
    }

    private String createQuery(Map<String, Collection<AttributeBean>> attributeMap) {
        StringBuilder sb = new StringBuilder(256);
        sb.append("collection('");
        sb.append(this.m_dbXmlManager.CONTAINER);
        sb.append("')");
        DbXmlPolicyIndex.getXpath(attributeMap, sb);
        return sb.toString();
    }

    @Override
    public String addPolicy(String name, String document) throws PolicyIndexException {
        String docName = null;
        DbXmlManager.writeLock.lock();
        try {
            XmlDocument doc = this.makeDocument(name, document);
            docName = doc.getName();
            log.debug("Adding document: " + docName);
            this.m_dbXmlManager.container.putDocument(doc, this.m_dbXmlManager.updateContext);
            this.setLastUpdate(System.currentTimeMillis());
        }
        catch (XmlException xe) {
            if (xe.getErrorCode() == 19) {
                throw new PolicyIndexException("Document already exists: " + docName);
            }
            throw new PolicyIndexException("Error adding policy: " + xe.getMessage(), xe);
        }
        finally {
            DbXmlManager.writeLock.unlock();
        }
        return docName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePolicy(String name) throws PolicyIndexException {
        block6: {
            log.debug("Deleting document: " + name);
            DbXmlManager.writeLock.lock();
            try {
                this.m_dbXmlManager.container.deleteDocument(name, this.m_dbXmlManager.updateContext);
                this.setLastUpdate(System.currentTimeMillis());
            }
            catch (XmlException xe) {
                if (xe.getDbError() == 11) {
                    log.warn("Error deleting document: " + name + " - document does not exist");
                    break block6;
                }
                throw new PolicyIndexException("Error deleting document: " + name + xe.getMessage(), xe);
            }
            finally {
                DbXmlManager.writeLock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean updatePolicy(String name, String newDocument) throws PolicyIndexException {
        log.debug("Updating document: " + name);
        this.deletePolicy(name);
        this.addPolicy(name, newDocument);
        return true;
    }

    @Override
    public AbstractPolicy getPolicy(String name, PolicyFinder policyFinder) throws PolicyIndexException {
        log.debug("Getting document: " + name);
        XmlDocument doc = null;
        DbXmlManager.readLock.lock();
        try {
            doc = this.m_dbXmlManager.container.getDocument(name);
            AbstractPolicy abstractPolicy = this.handleDocument(this.m_policyReader.readPolicy(doc.getContent()), policyFinder);
            return abstractPolicy;
        }
        catch (XmlException xe) {
            throw new PolicyIndexException("Error getting Policy: " + name + xe.getMessage() + " - " + xe.getDatabaseException().getMessage(), xe);
        }
        catch (ParsingException pe) {
            throw new PolicyIndexException("Error getting Policy: " + name + pe.getMessage(), pe);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
    }

    @Override
    public boolean contains(String policyName) throws PolicyIndexException {
        log.debug("Determining if document exists: " + policyName);
        DbXmlManager.readLock.lock();
        try {
            this.m_dbXmlManager.container.getDocument(policyName, new XmlDocumentConfig().setLazyDocs(true));
        }
        catch (XmlException e) {
            if (e.getErrorCode() == 11) {
                boolean bl = false;
                return bl;
            }
            throw new PolicyIndexException("Error executing contains. " + e.getMessage(), e);
        }
        finally {
            DbXmlManager.readLock.unlock();
        }
        return true;
    }

    private XmlDocument makeDocument(String name, String document) throws XmlException, PolicyIndexException {
        Map<String, String> metadata = this.m_utils.getDocumentMetadata(document.getBytes());
        XmlDocument doc = this.m_dbXmlManager.manager.createDocument();
        String docName = name;
        if (docName == null || docName.isEmpty()) {
            docName = metadata.get("PolicyId");
        }
        if (docName == null || docName.isEmpty()) {
            throw new PolicyIndexException("Could not extract PolicyID from document.");
        }
        doc.setMetaData("metadata", "PolicyId", new XmlValue(29, docName));
        doc.setContent(document);
        doc.setName(docName);
        String item = null;
        item = metadata.get("anySubject");
        if (item != null) {
            doc.setMetaData("metadata", "anySubject", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyResource")) != null) {
            doc.setMetaData("metadata", "anyResource", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyAction")) != null) {
            doc.setMetaData("metadata", "anyAction", new XmlValue(29, item));
        }
        if ((item = metadata.get("anyEnvironment")) != null) {
            doc.setMetaData("metadata", "anyEnvironment", new XmlValue(29, item));
        }
        return doc;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public void setLastUpdate(long lastUpdate) {
        this.m_lastUpdate = lastUpdate;
    }

    @Override
    public boolean clear() throws PolicyIndexException {
        this.m_dbXmlManager.deleteDatabase();
        this.m_dbXmlManager.close();
        this.m_dbXmlManager = null;
        this.init();
        return true;
    }

    private boolean deleteDirectory(String directory) {
        File file;
        boolean result = false;
        if (directory != null && (file = new File(directory)).exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            result = true;
            for (File f : files) {
                if (f.isFile()) {
                    result = result && f.delete();
                    continue;
                }
                if (!f.isDirectory()) continue;
                result = result && this.deleteDirectory(f.getAbsolutePath());
            }
            file.delete();
        }
        return result;
    }
}

