/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexBase;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.data.XPathPolicyIndex;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyReader;
import org.fcrepo.server.security.xacml.util.AttributeBean;
import org.fcrepo.utilities.xml.SunXmlSerializers;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

@Deprecated
public class ExistPolicyIndex
extends XPathPolicyIndex
implements PolicyIndex {
    private static final Logger log = LoggerFactory.getLogger((String)ExistPolicyIndex.class.getName());
    private static final String ROOT_COLLECTION_PATH = "/db";
    private static final String INDEX_DOCUMENT_NAME = "collection.xconf";
    private String m_databaseURI;
    private String m_collectionName;
    private String m_collectionPath;
    private String m_indexCollectionPath;
    private String m_user;
    private String m_password;
    protected org.xmldb.api.base.Collection m_collection;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private static final Lock readLock = rwl.readLock();
    private static final Lock writeLock = rwl.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExistPolicyIndex(PolicyReader policyReader) throws PolicyIndexException {
        super(policyReader);
        try {
            writeLock.lock();
            this.initCollection();
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public String addPolicy(String name, String document) throws PolicyIndexException {
        String Id = ExistPolicyIndex.nameToId(name);
        try {
            writeLock.lock();
            XMLResource res = (XMLResource)this.m_collection.getResource(Id);
            if (res != null) {
                throw new PolicyIndexException("Tried to add an already-existing resource " + name);
            }
            res = (XMLResource)this.m_collection.createResource(Id, "XMLResource");
            res.setContentAsDOM((Node)ExistPolicyIndex.createDocument(document));
            this.m_collection.storeResource((Resource)res);
        }
        catch (XMLDBException e) {
            log.error("Error adding resource " + name + " " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error adding resource " + name + " " + e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear() throws PolicyIndexException {
        try {
            writeLock.lock();
            this.deleteCollection();
            this.initCollection();
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    @Override
    public boolean contains(String policyName) throws PolicyIndexException {
        try {
            readLock.lock();
            boolean bl = this.m_collection.getResource(ExistPolicyIndex.nameToId(policyName)) != null;
            return bl;
        }
        catch (XMLDBException e) {
            log.error("Error determining if db contains " + policyName + " - " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error determining if db contains " + policyName + " - " + e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean deletePolicy(String name) throws PolicyIndexException {
        String Id = ExistPolicyIndex.nameToId(name);
        try {
            writeLock.lock();
            Resource res = this.m_collection.getResource(Id);
            if (res == null) {
                log.warn("Attempted to delete non-existing resource " + name);
                boolean bl = false;
                return bl;
            }
            this.m_collection.removeResource(res);
        }
        catch (XMLDBException e) {
            log.error("Error deleting resource " + name + " " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error deleting resource " + name + " " + e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, AbstractPolicy> getPolicies(EvaluationCtx eval, PolicyFinder policyFinder) throws PolicyIndexException {
        Map<String, Collection<AttributeBean>> attributeMap;
        try {
            attributeMap = this.getAttributeMap(eval);
        }
        catch (URISyntaxException e) {
            log.error("Error getting attribute map " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error getting attribute map " + e.getMessage(), e);
        }
        HashMap<String, AbstractPolicy> documents = new HashMap<String, AbstractPolicy>();
        String query = ExistPolicyIndex.getXpath(attributeMap);
        Map<String, String> variables = ExistPolicyIndex.getXpathVariables(attributeMap);
        try {
            readLock.lock();
            ResourceSet resources = this.doQuery(query, variables);
            try {
                ResourceIterator ri = resources.getIterator();
                while (ri.hasMoreResources()) {
                    XMLResource res = (XMLResource)ri.nextResource();
                    String id = res.getDocumentId();
                    log.trace("Query matched document: " + ExistPolicyIndex.IdToName(id));
                    Document policyDoc = this.m_policyReader.readPolicy(((String)this.m_collection.getResource(id).getContent()).getBytes("UTF-8"));
                    documents.put(ExistPolicyIndex.IdToName(id), this.handleDocument(policyDoc, policyFinder));
                }
            }
            catch (XMLDBException e) {
                log.error("Error retrieving query results " + e.getMessage(), (Throwable)e);
                throw new PolicyIndexException("Error retrieving query results " + e.getMessage(), e);
            }
            catch (ParsingException e) {
                log.error("Error retrieving query results " + e.getMessage(), (Throwable)e);
                throw new PolicyIndexException("Error retrieving query results " + e.getMessage(), e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Unsupported encoding " + e.getMessage(), e);
            }
        }
        finally {
            readLock.unlock();
        }
        return documents;
    }

    @Override
    public AbstractPolicy getPolicy(String name, PolicyFinder policyFinder) throws PolicyIndexException {
        try {
            readLock.lock();
            XMLResource resource = (XMLResource)this.m_collection.getResource(ExistPolicyIndex.nameToId(name));
            if (resource == null) {
                log.error("Attempting to get non-existant resource " + name);
                throw new PolicyIndexException("Attempting to get non-existant resource " + name);
            }
            Document policyDoc = this.m_policyReader.readPolicy(((String)resource.getContent()).getBytes("UTF-8"));
            AbstractPolicy abstractPolicy = this.handleDocument(policyDoc, policyFinder);
            return abstractPolicy;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding " + e.getMessage(), e);
        }
        catch (XMLDBException e) {
            log.error("Error getting policy " + name + " " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error getting policy " + name + " " + e.getMessage(), e);
        }
        catch (ParsingException e) {
            log.error("Error getting policy " + name + " " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error getting policy " + name + " " + e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean updatePolicy(String name, String newDocument) throws PolicyIndexException {
        String Id = ExistPolicyIndex.nameToId(name);
        try {
            writeLock.lock();
            XMLResource res = (XMLResource)this.m_collection.getResource(Id);
            if (res == null) {
                log.error("Tried to update non-existing resource " + name);
                throw new PolicyIndexException("Tried to update non-existing resource " + name);
            }
            res.setContentAsDOM((Node)ExistPolicyIndex.createDocument(newDocument));
            this.m_collection.storeResource((Resource)res);
        }
        catch (XMLDBException e) {
            log.error("Error updating resource " + name + " " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error updating resource " + name + " " + e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    @Deprecated
    protected static byte[] nodeToByte(Node node) throws PolicyIndexException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter output = new OutputStreamWriter((OutputStream)out, Charset.forName("UTF-8"));
        try {
            SunXmlSerializers.writePrettyPrintWithDecl((Node)node, (Writer)output);
            ((Writer)output).close();
        }
        catch (IOException e) {
            throw new PolicyIndexException("Failed to serialise node " + e.getMessage(), e);
        }
        return out.toByteArray();
    }

    protected static String nameToId(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding", e);
        }
    }

    protected static String IdToName(String Id) {
        try {
            return URLDecoder.decode(Id, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding", e);
        }
    }

    protected static String[] sortDescending(String[] s) {
        Arrays.sort(s, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() < o2.length()) {
                    return 1;
                }
                if (o1.length() > o2.length()) {
                    return -1;
                }
                return 0;
            }
        });
        return s;
    }

    protected ResourceSet doQuery(String query, Map<String, String> variables) throws PolicyIndexException {
        try {
            String[] varNames;
            XPathQueryService queryService = (XPathQueryService)this.m_collection.getService("XPathQueryService", "1.0");
            for (String prefix : PolicyIndexBase.namespaces.keySet()) {
                queryService.setNamespace(prefix, PolicyIndexBase.namespaces.get(prefix));
            }
            for (String name : varNames = ExistPolicyIndex.sortDescending(variables.keySet().toArray(new String[0]))) {
                query = query.replace("$" + name, "\"" + variables.get(name) + "\"");
            }
            log.trace("XPath query with variables substituted:\n" + query);
            long start = System.nanoTime();
            ResourceSet results = queryService.query(query);
            log.debug("XPath query time: " + (System.nanoTime() - start) + "ns");
            return results;
        }
        catch (XMLDBException e) {
            log.error("Error running query " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error running query " + e.getMessage(), e);
        }
    }

    protected org.xmldb.api.base.Collection createCollectionPath(String collectionPath, org.xmldb.api.base.Collection rootCollection) throws PolicyIndexException {
        try {
            if (rootCollection.getParentCollection() != null) {
                throw new PolicyIndexException("Collection supplied is not a root collection");
            }
            String rootCollectionName = rootCollection.getName();
            if (!collectionPath.startsWith(rootCollectionName)) {
                throw new PolicyIndexException("Collection path " + collectionPath + " does not start from root collection - " + rootCollectionName);
            }
            String pathToCreate = collectionPath.substring(rootCollectionName.length());
            String[] collections = pathToCreate.split("/");
            org.xmldb.api.base.Collection nextCollection = rootCollection;
            for (String collectionName : collections) {
                org.xmldb.api.base.Collection childCollection = nextCollection.getChildCollection(collectionName);
                if (childCollection != null) {
                    childCollection = nextCollection.getChildCollection(collectionName);
                } else {
                    CollectionManagementService mgtService = (CollectionManagementService)nextCollection.getService("CollectionManagementService", "1.0");
                    childCollection = mgtService.createCollection(collectionName);
                    log.debug("Created collection " + collectionName);
                }
                if (nextCollection.isOpen()) {
                    nextCollection.close();
                }
                nextCollection = childCollection;
            }
            return nextCollection;
        }
        catch (XMLDBException e) {
            log.error("Error creating collections from path " + e.getMessage(), (Throwable)e);
            throw new PolicyIndexException("Error creating collections from path " + e.getMessage(), e);
        }
    }

    public void setDatabaseURI(String databaseURI) {
        this.m_databaseURI = databaseURI;
    }

    public void setCollectionName(String collectionName) {
        this.m_collectionName = collectionName;
        this.m_indexCollectionPath = "/db/system/config/db/" + this.m_collectionName;
        this.m_collectionPath = "/db/" + this.m_collectionName;
    }

    public void setUser(String user) {
        this.m_user = user;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public void init() throws PolicyIndexException {
        this.initDatabase();
        this.initCollection();
    }

    public void initDatabase() throws PolicyIndexException {
        Database database;
        Class<?> cl;
        String databaseImplClassName = "org.exist.xmldb.DatabaseImpl";
        try {
            cl = Class.forName(databaseImplClassName);
        }
        catch (ClassNotFoundException e) {
            log.error("Class not found - check xmldb driver classes are on classpath " + e.getMessage());
            throw new PolicyIndexException("Class not found - check xmldb driver classes are on classpath " + e.getMessage(), e);
        }
        try {
            database = (Database)cl.newInstance();
        }
        catch (Exception e) {
            log.error("Error instantiating xmldb driver", (Throwable)e);
            throw new PolicyIndexException("Error instantiating xmldb driver", e);
        }
        try {
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
        }
        catch (XMLDBException e) {
            throw new PolicyIndexException("Error registering xmldb driver " + e.getMessage(), e);
        }
    }

    protected void initCollection() throws PolicyIndexException {
        try {
            this.m_collection = DatabaseManager.getCollection((String)(this.m_databaseURI + this.m_collectionPath), (String)this.m_user, (String)this.m_password);
            if (this.m_collection == null) {
                XMLResource ixd;
                org.xmldb.api.base.Collection rootCol = DatabaseManager.getCollection((String)(this.m_databaseURI + ROOT_COLLECTION_PATH), (String)this.m_user, (String)this.m_password);
                CollectionManagementService mgtService = (CollectionManagementService)rootCol.getService("CollectionManagementService", "1.0");
                org.xmldb.api.base.Collection indexCollection = DatabaseManager.getCollection((String)(this.m_databaseURI + this.m_indexCollectionPath), (String)this.m_user, (String)this.m_password);
                if (indexCollection == null) {
                    log.debug("creating index collection");
                    indexCollection = this.createCollectionPath(this.m_indexCollectionPath, rootCol);
                }
                if (rootCol.isOpen()) {
                    rootCol.close();
                }
                if ((ixd = (XMLResource)indexCollection.getResource(INDEX_DOCUMENT_NAME)) == null) {
                    ixd = (XMLResource)indexCollection.createResource(INDEX_DOCUMENT_NAME, "XMLResource");
                }
                String configDoc = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><collection xmlns=\"http://exist-db.org/collection-config/1.0\"><index xmlns:p=\"urn:oasis:names:tc:xacml:2.0:policy:schema:os\"><create qname=\"p:AttributeValue\" type=\"xs:string\"/><create qname=\"@AttributeId\" type=\"xs:string\"/></index></collection>";
                Document config = ExistPolicyIndex.createDocument(configDoc);
                log.debug("Storing index document");
                ixd.setContentAsDOM((Node)config);
                indexCollection.storeResource((Resource)ixd);
                indexCollection.close();
                log.debug("Creating policy collection");
                this.m_collection = mgtService.createCollection(this.m_collectionName);
            }
        }
        catch (XMLDBException e) {
            throw new PolicyIndexException("Error getting/creating policy collection " + e.getMessage(), e);
        }
    }

    protected void deleteCollection() throws PolicyIndexException {
        try {
            org.xmldb.api.base.Collection rootCol = DatabaseManager.getCollection((String)(this.m_databaseURI + ROOT_COLLECTION_PATH), (String)this.m_user, (String)this.m_password);
            CollectionManagementService mgtService = (CollectionManagementService)rootCol.getService("CollectionManagementService", "1.0");
            mgtService.removeCollection(this.m_collectionName);
            log.debug("Policy collection deleted");
        }
        catch (XMLDBException e) {
            throw new PolicyIndexException("Error deleting collection " + e.getMessage(), e);
        }
    }

    protected static Document createDocument(String document) throws PolicyIndexException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(document)));
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new PolicyIndexException(e);
        }
        catch (SAXException e) {
            throw new PolicyIndexException(e);
        }
        catch (IOException e) {
            throw new PolicyIndexException(e);
        }
    }

    public void close() {
        try {
            this.m_collection.close();
        }
        catch (XMLDBException e) {
            log.warn("Error closing connection " + e.getMessage(), (Throwable)e);
        }
    }
}

