/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class PolicyUtils {
    private static final Logger log = LoggerFactory.getLogger((String)PolicyUtils.class.getName());

    public String fileToString(File f) throws MelcoePDPException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        try {
            FileInputStream fis = new FileInputStream(f);
            int count = fis.read(bytes);
            while (count > -1) {
                out.write(bytes, 0, count);
                count = fis.read(bytes);
            }
            fis.close();
        }
        catch (IOException e) {
            throw new MelcoePDPException("Error reading file: " + f.getName(), e);
        }
        return out.toString();
    }

    public String getPolicyName(File policy) throws MelcoePDPException {
        String policyName;
        try {
            FileInputStream is = new FileInputStream(policy);
            Map<String, String> metadata = this.getDocumentMetadata(is);
            ((InputStream)is).close();
            policyName = metadata.get("PolicyId");
        }
        catch (IOException e) {
            throw new MelcoePDPException(e.getMessage(), e);
        }
        return policyName;
    }

    public String getPolicyName(String policy) throws MelcoePDPException {
        Map<String, String> metadata;
        try {
            metadata = this.getDocumentMetadata(policy.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new MelcoePDPException(e.getMessage(), e);
        }
        return metadata.get("PolicyId");
    }

    public Map<String, String> getDocumentMetadata(byte[] docData) {
        ByteArrayInputStream docIS = new ByteArrayInputStream(docData);
        return this.getDocumentMetadata(docIS);
    }

    public Map<String, String> getDocumentMetadata(InputStream docIS) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(docIS);
            NodeList nodes = null;
            metadata.put("PolicyId", doc.getDocumentElement().getAttribute("PolicyId"));
            nodes = doc.getElementsByTagName("Subjects");
            if (nodes.getLength() == 0) {
                metadata.put("anySubject", "T");
            }
            if ((nodes = doc.getElementsByTagName("Resources")).getLength() == 0) {
                metadata.put("anyResource", "T");
            }
            if ((nodes = doc.getElementsByTagName("Actions")).getLength() == 0) {
                metadata.put("anyAction", "T");
            }
            if ((nodes = doc.getElementsByTagName("Environments")).getLength() == 0) {
                metadata.put("anyEnvironment", "T");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return metadata;
    }
}

