/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.finder.attribute;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;
import org.fcrepo.server.security.xacml.pdp.finder.attribute.DesignatorAttributeFinderModule;
import org.fcrepo.server.security.xacml.util.Attribute;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.attr.StandardAttributeFactory;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FedoraRIAttributeFinder
extends DesignatorAttributeFinderModule {
    private static final Logger logger = LoggerFactory.getLogger(FedoraRIAttributeFinder.class);
    private AttributeFactory m_attributeFactory = null;
    private RelationshipResolver m_relationshipResolver = null;

    public FedoraRIAttributeFinder(RelationshipResolver relationshipResolver) {
        this.m_relationshipResolver = relationshipResolver;
        this.m_attributeFactory = StandardAttributeFactory.getFactory();
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        String resourceId = context.getResourceId().encode();
        if (logger.isDebugEnabled()) {
            logger.debug("RIAttributeFinder: [" + attributeType.toString() + "] " + attributeId + ", rid=" + resourceId);
        }
        if (resourceId == null || resourceId.isEmpty()) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        if (resourceId.equals("/FedoraRepository")) {
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        String attrName = attributeId.toString();
        Map allowedAttributes = (Map)this.m_attributes.get(designatorType);
        if (allowedAttributes == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about designatorType: " + designatorType);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        Attribute attribute = (Attribute)allowedAttributes.get(attrName);
        if (attribute == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Does not know about attribute: " + attrName);
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        EvaluationResult result = null;
        try {
            result = this.getEvaluationResult(resourceId, attrName, attribute, attributeType);
        }
        catch (Exception e) {
            logger.error("Error finding attribute: " + e.getMessage(), (Throwable)e);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        return result;
    }

    private EvaluationResult getEvaluationResult(String resourceID, String attributeID, Attribute attribute, URI type) throws AttributeFinderException {
        Set<String> results;
        String pid;
        String subject;
        String[] resourceParts = resourceID.split("/");
        if (resourceParts.length > 1) {
            if (resourceParts[resourceParts.length - 1].contains(":")) {
                pid = subject = resourceParts[resourceParts.length - 1];
            } else {
                pid = resourceParts[resourceParts.length - 2];
                subject = pid + "/" + resourceParts[resourceParts.length - 1];
            }
        } else {
            logger.debug("Resource ID not valid path to PID or datastream: " + resourceID);
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
        }
        logger.debug("Getting attribute for resource " + subject);
        String query = attribute.get("query");
        if (query == null) {
            Map<String, Set<String>> relationships;
            String target;
            String relationship = attribute.get("relationship");
            if (relationship == null) {
                relationship = attributeID;
            }
            String queryTarget = (target = attribute.get("target")) != null && target.equals("object") ? pid : subject;
            try {
                logger.debug("Getting attribute using relationship " + relationship);
                relationships = this.m_relationshipResolver.getRelationships(queryTarget, relationship);
            }
            catch (MelcoeXacmlException e) {
                throw new AttributeFinderException(e.getMessage(), e);
            }
            if (relationships == null || relationships.isEmpty()) {
                return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)type));
            }
            results = relationships.get(relationship);
        } else {
            String queryLang = attribute.get("queryLang");
            String variable = attribute.get("value");
            String resource = attribute.get("resource");
            String object = attribute.get("object");
            String subjectURI = "info:fedora/" + subject;
            String pidURI = "info:fedora/" + pid;
            if (resource != null) {
                query = query.replace(resource, subjectURI);
            }
            if (object != null) {
                query = query.replace(object, pidURI);
            }
            try {
                logger.debug("Using a " + queryLang + " query to get attribute " + attribute);
                results = this.m_relationshipResolver.getAttributesFromQuery(query, queryLang, variable);
            }
            catch (MelcoeXacmlException e) {
                throw new AttributeFinderException(e.getMessage(), e);
            }
        }
        HashSet<AttributeValue> bagValues = new HashSet<AttributeValue>();
        logger.debug("Attribute values found: " + results.size());
        for (String s : results) {
            AttributeValue attributeValue = null;
            try {
                attributeValue = this.m_attributeFactory.createValue(type, s);
            }
            catch (Exception e) {
                logger.error("Error creating attribute: " + e.getMessage(), (Throwable)e);
                continue;
            }
            bagValues.add(attributeValue);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("AttributeValue found: [" + type.toASCIIString() + "] " + s);
        }
        BagAttribute bag = new BagAttribute(type, bagValues);
        return new EvaluationResult((AttributeValue)bag);
    }
}

