/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipResolverImpl
implements RelationshipResolver {
    private static final Logger logger = LoggerFactory.getLogger(RelationshipResolverImpl.class);
    private static String DEFAULT_RELATIONSHIP = "info:fedora/fedora-system:def/relations-external#isMemberOf";
    private final List<String> relationships = new ArrayList<String>();
    private Management apim;
    private Context fedoraCtx;

    public RelationshipResolverImpl() {
        this(new HashMap<String, String>());
    }

    public RelationshipResolverImpl(Map<String, String> options) {
        if (options.isEmpty()) {
            this.relationships.add(DEFAULT_RELATIONSHIP);
        } else {
            ArrayList<String> keys = new ArrayList<String>(options.keySet());
            Collections.sort(keys);
            for (String s : keys) {
                if (!s.startsWith("parent-child-relationship")) continue;
                this.relationships.add(options.get(s));
            }
        }
    }

    @Override
    public String buildRESTParentHierarchy(String pid) throws MelcoeXacmlException {
        Set<String> parents = this.getParents(pid);
        if (parents == null || parents.size() == 0) {
            return "/" + pid;
        }
        String[] parentArray = parents.toArray(new String[parents.size()]);
        return this.buildRESTParentHierarchy(parentArray[0]) + "/" + pid;
    }

    public Set<String> getParents(String pid) throws MelcoeXacmlException {
        logger.debug("Obtaining parents for: {}", (Object)pid);
        HashSet<String> parentPIDs = new HashSet<String>();
        if (pid.equalsIgnoreCase(Constants.FEDORA_REPOSITORY_PID.uri)) {
            return parentPIDs;
        }
        for (String relationship : this.relationships) {
            Map<String, Set<String>> mapping;
            logger.debug("relationship query: {}, {}", (Object)pid, (Object)relationship);
            try {
                mapping = this.getRelationships(pid, relationship);
            }
            catch (MelcoeXacmlException e) {
                Throwable t = e.getCause();
                if (t != null && t instanceof ObjectNotInLowlevelStorageException) {
                    logger.debug("Parent, {}, not found.", (Object)pid);
                    break;
                }
                throw e;
            }
            Set<String> parents = mapping.get(relationship);
            if (parents == null) continue;
            for (String parent : parents) {
                PID parentPID = PID.getInstance((String)parent);
                parentPIDs.add(parentPID.toString());
                logger.debug("added parent {}", (Object)parentPID.toString());
            }
        }
        return parentPIDs;
    }

    protected String getSubjectURI(String subject) throws MalformedPIDException {
        String subjectURI;
        String strippedSubject = subject.startsWith(Constants.FEDORA.uri) ? subject.substring(Constants.FEDORA.uri.length()) : subject;
        String[] parts = strippedSubject.split("/");
        PID pid = new PID(parts[0]);
        if (parts.length == 1) {
            subjectURI = pid.toURI();
        } else if (parts.length == 2) {
            subjectURI = pid.toURI() + "/" + parts[1];
        } else {
            logger.warn("Invalid subject argument for getRelationships: " + subject + ". Should be pid or datastream (URI form optional");
            subjectURI = null;
        }
        return subjectURI;
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject) throws MelcoeXacmlException {
        return this.getRelationships(subject, null);
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject, String relationship) throws MelcoeXacmlException {
        RelationshipTuple[] tuples;
        String subjectURI;
        try {
            subjectURI = this.getSubjectURI(subject);
            if (subjectURI == null) {
                return new HashMap<String, Set<String>>();
            }
        }
        catch (MalformedPIDException e1) {
            logger.warn("Invalid subject argument for getRelationships: " + subject + ". PID part of URI is malformed");
            return new HashMap<String, Set<String>>();
        }
        try {
            tuples = this.getApiM().getRelationships(this.getContext(), subjectURI, relationship);
        }
        catch (ServerException e) {
            throw new MelcoeXacmlException(e.getMessage(), e);
        }
        HashMap<String, Set<String>> relationships = new HashMap<String, Set<String>>();
        for (RelationshipTuple t : tuples) {
            String p = t.predicate;
            String o = t.object;
            HashSet<String> values = (HashSet<String>)relationships.get(p);
            if (values == null) {
                values = new HashSet<String>();
            }
            values.add(o);
            relationships.put(p, values);
        }
        return relationships;
    }

    private Management getApiM() {
        Server server;
        if (this.apim != null) {
            return this.apim;
        }
        try {
            server = Server.getInstance((File)new File(Constants.FEDORA_HOME), (boolean)false);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new RuntimeException("Failed getting instance of Fedora", e);
        }
        this.apim = (Management)server.getModule("org.fcrepo.server.management.Management");
        return this.apim;
    }

    private Context getContext() throws MelcoeXacmlException {
        if (this.fedoraCtx != null) {
            return this.fedoraCtx;
        }
        try {
            this.fedoraCtx = ReadOnlyContext.getContext(null, null, null, (boolean)false);
        }
        catch (Exception e) {
            throw new MelcoeXacmlException(e.getMessage(), e);
        }
        return this.fedoraCtx;
    }

    protected PID getNormalizedPID(String pid) {
        if (pid.startsWith(Constants.FEDORA.uri)) {
            pid = pid.substring(Constants.FEDORA.uri.length());
        }
        return PID.getInstance((String)pid.split("\\/")[0]);
    }

    @Override
    public Set<String> getAttributesFromQuery(String query, String queryLang, String variable) throws MelcoeXacmlException {
        logger.warn("RELS relationship resolver does not support retrieving attributes with an RI query");
        return Collections.emptySet();
    }
}

