/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.fcrepo.server.security.RequestCtx;
import org.fcrepo.server.security.impl.BasicEvaluationCtx;
import org.fcrepo.server.security.impl.BasicRequestCtx;
import org.fcrepo.server.security.xacml.pdp.EvaluationException;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.PDP;
import org.jboss.security.xacml.sunxacml.PDPConfig;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MelcoePDPImpl
implements MelcoePDP {
    private static final Logger logger = LoggerFactory.getLogger(MelcoePDPImpl.class);
    private final PDP m_pdp;
    private final AttributeFinder m_finder;

    public MelcoePDPImpl(PDPConfig pdpConfig) throws MelcoePDPException {
        this.m_pdp = new PDP(pdpConfig);
        this.m_finder = pdpConfig.getAttributeFinder();
        logger.info("PDP Instantiated and initialised!");
    }

    @Override
    public String evaluate(String request) throws EvaluationException {
        logger.debug("evaluating request: {}", (Object)request);
        RequestCtx req = null;
        ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
        try {
            req = BasicRequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            logger.error("Error parsing request:\n" + request, (Throwable)pe);
            throw new EvaluationException("Error parsing request:\n" + request);
        }
        ResponseCtx res = this.evaluate(req);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        res.encode((OutputStream)os, new Indenter());
        if (logger.isDebugEnabled()) {
            logger.debug("response is: {}", (Object)os.toString());
        }
        return os.toString();
    }

    @Override
    public ResponseCtx evaluate(RequestCtx request) throws EvaluationException {
        try {
            BasicEvaluationCtx evalCtx = new BasicEvaluationCtx(request, this.m_finder);
            return this.m_pdp.evaluate((EvaluationCtx)evalCtx);
        }
        catch (ParsingException pe) {
            logger.error("Error parsing request:\n" + request, (Throwable)pe);
            throw new EvaluationException("Error parsing request:\n" + request);
        }
    }

    @Override
    public String evaluateBatch(String[] requests) throws EvaluationException {
        logger.debug("evaluating string request batch");
        RequestCtx[] requestCtxs = new RequestCtx[requests.length];
        for (int i = 0; i < requests.length; ++i) {
            String request = requests[i];
            ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
            try {
                requestCtxs[i] = BasicRequestCtx.getInstance((InputStream)is);
                continue;
            }
            catch (ParsingException pe) {
                logger.error("Error parsing request:\n" + request, (Throwable)pe);
                throw new EvaluationException("Error parsing request:\n" + request);
            }
        }
        ResponseCtx combinedResponse = this.evaluateBatch(requestCtxs);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        combinedResponse.encode((OutputStream)os, new Indenter());
        return os.toString();
    }

    @Override
    public ResponseCtx evaluateBatch(RequestCtx[] requests) throws EvaluationException {
        logger.debug("evaluating request batch");
        HashSet results = new HashSet();
        for (RequestCtx request : requests) {
            ResponseCtx response = this.evaluate(request);
            Set r = response.getResults();
            results.addAll(r);
        }
        return new ResponseCtx(results);
    }
}

