/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.Server;
import org.fcrepo.server.access.Access;
import org.fcrepo.server.access.ObjectProfile;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.security.xacml.pdp.MelcoePDPException;
import org.fcrepo.server.security.xacml.pdp.data.AbstractPolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStore;
import org.fcrepo.server.security.xacml.pdp.data.PolicyStoreException;
import org.fcrepo.server.security.xacml.pdp.data.PolicyUtils;
import org.fcrepo.server.utilities.StreamUtility;
import org.fcrepo.server.validation.ValidationUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class FedoraPolicyStore
extends AbstractPolicyStore
implements PolicyStore {
    private static final Logger log = LoggerFactory.getLogger((String)FedoraPolicyStore.class.getName());
    private static final String XACML20_POLICY_NS = Constants.XACML2_POLICY_SCHEMA.OS.uri;
    public static final String FESL_POLICY_DATASTREAM = "FESLPOLICY";
    public static String FESL_BOOTSTRAP_POLICY_NAMESPACE = "fedora-policy";
    private static final String PID_SEPARATOR_ESCAPED = "%3A";
    private String pidNamespace = "";
    private String contentModel = "";
    private String datastreamControlGroup = "";
    private String collection = "";
    private String collectionRelationship = "";
    private boolean validateSchema = false;
    private Map<String, String> schemaLocations = null;
    private final PolicyUtils utils = new PolicyUtils();
    protected Server fedoraServer;
    protected Management apiMService;
    protected Access apiAService;

    public FedoraPolicyStore(Server server) throws PolicyStoreException {
        this.fedoraServer = server;
        this.apiMService = (Management)server.getBean("org.fcrepo.server.management.Management");
        this.apiAService = (Access)server.getBean("org.fcrepo.server.access.Access");
    }

    @Override
    public void init() throws PolicyStoreException, FileNotFoundException {
        if (log.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            log.debug("Total memory: " + runtime.totalMemory() / 1024L);
            log.debug("Free memory: " + runtime.freeMemory() / 1024L);
            log.debug("Max memory: " + runtime.maxMemory() / 1024L);
        }
        super.init();
        if (this.pidNamespace.isEmpty()) {
            this.pidNamespace = this.fedoraServer.getModule("org.fcrepo.server.storage.DOManager").getParameter("pidNamespace");
        }
        if (this.datastreamControlGroup.isEmpty()) {
            throw new PolicyStoreException("No control group for policy datastreams was specified in FedoraPolicyStore configuration");
        }
        if (this.validateSchema) {
            String schemaLocation = this.schemaLocations.get(XACML20_POLICY_NS);
            if (schemaLocation == null) {
                throw new PolicyStoreException("Configuration error - no policy schema specified");
            }
            try {
                String serverHome = this.fedoraServer.getHomeDir().getCanonicalPath() + File.separator;
                String schemaPath = (schemaLocation.startsWith(File.separator) ? "" : serverHome) + schemaLocation;
                FileInputStream in = new FileInputStream(schemaPath);
                PolicyParser policyParser = new PolicyParser((InputStream)in);
                ValidationUtility.setFeslPolicyParser((PolicyParser)policyParser);
            }
            catch (IOException ioe) {
                throw new PolicyStoreException(ioe.getMessage(), ioe);
            }
            catch (SAXException se) {
                throw new PolicyStoreException(se.getMessage(), se);
            }
        }
    }

    public void setPidNamespace(String pidNamespace) {
        this.pidNamespace = pidNamespace;
    }

    public void setContentModel(String contentModel) {
        this.contentModel = contentModel;
    }

    public void setDatastreamControlGroup(String datastreamControlGroup) {
        this.datastreamControlGroup = datastreamControlGroup;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setCollectionRelationship(String collectionRelationship) {
        this.collectionRelationship = collectionRelationship;
    }

    public void setSchemaValidation(boolean validate) {
        this.validateSchema = validate;
        log.info("Initialising validation " + Boolean.toString(validate));
        ValidationUtility.setValidateFeslPolicy((boolean)validate);
    }

    public void setSchemaLocations(Map<String, String> schemaLocation) throws IOException, SAXException {
        this.schemaLocations = schemaLocation;
    }

    @Override
    public String addPolicy(File f) throws PolicyStoreException {
        return this.addPolicy(f, null);
    }

    @Override
    public String addPolicy(File f, String name) throws PolicyStoreException {
        try {
            return this.addPolicy(this.utils.fileToString(f), name);
        }
        catch (MelcoePDPException e) {
            throw new PolicyStoreException(e);
        }
    }

    @Override
    public String addPolicy(String document) throws PolicyStoreException {
        return this.addPolicy(document, null);
    }

    @Override
    public String addPolicy(String document, String name) throws PolicyStoreException {
        String policyName;
        if (name == null || name.isEmpty()) {
            try {
                policyName = this.utils.getPolicyName(document);
            }
            catch (MelcoePDPException e) {
                throw new PolicyStoreException("Could not get policy name from policy", e);
            }
            if (name.contains(":")) {
                name = name.replace(":", PID_SEPARATOR_ESCAPED);
            }
        } else {
            policyName = name;
        }
        String pid = this.getPID(policyName);
        ObjectProfile objectProfile = null;
        try {
            objectProfile = this.apiAService.getObjectProfile(this.getContext(), pid, null);
        }
        catch (ObjectNotInLowlevelStorageException objectNotInLowlevelStorageException) {
        }
        catch (ServerException e) {
            throw new PolicyStoreException("Add: error getting object profile for " + pid + " - " + e.getMessage(), e);
        }
        if (objectProfile != null) {
            if (objectProfile.objectState != "D") {
                throw new PolicyStoreException("Add:  attempting to add policy " + pid + " but it already exists");
            }
            try {
                this.apiMService.modifyObject(this.getContext(), pid, "A", objectProfile.objectLabel, objectProfile.objectOwnerId, "Fedora policy manager:  Adding policy by activating deleted object", null);
            }
            catch (ServerException e) {
                throw new PolicyStoreException("Add: " + e.getMessage(), e);
            }
            this.updatePolicy(policyName, document);
            return pid;
        }
        String dsLocationOrContent = null;
        if (this.datastreamControlGroup.equals("M")) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(document.getBytes("UTF-8"));
                dsLocationOrContent = this.apiMService.putTempStream(this.getContext(), (InputStream)is);
            }
            catch (Exception e) {
                throw new PolicyStoreException("Add: error generating temp datastream location - " + e.getMessage(), e);
            }
        } else {
            dsLocationOrContent = document;
        }
        try {
            return this.apiMService.ingest(this.getContext(), (InputStream)new ByteArrayInputStream(FedoraPolicyStore.getFOXMLPolicyTemplate(pid, "XACML policy " + policyName, this.contentModel, this.collection, this.collectionRelationship, dsLocationOrContent, this.datastreamControlGroup).getBytes("UTF-8")), "Fedora Policy Manager creating policy", Constants.FOXML1_1.uri, "UTF-8", "");
        }
        catch (Exception e) {
            throw new PolicyStoreException("Add: error ingesting " + pid + " - " + e.getMessage(), e);
        }
    }

    @Override
    public boolean deletePolicy(String name) throws PolicyStoreException {
        String pid = this.getPID(name);
        if (!this.contains(name)) {
            throw new PolicyStoreException("Delete: object " + pid + " not found.");
        }
        try {
            this.apiMService.modifyObject(this.getContext(), pid, "D", null, null, "Deleting policy " + pid, null);
        }
        catch (ServerException e) {
            throw new PolicyStoreException("Delete: error deleting policy " + pid + " - " + e.getMessage(), e);
        }
        return true;
    }

    @Override
    public boolean updatePolicy(String name, String newDocument) throws PolicyStoreException {
        String pid = this.getPID(name);
        if (!this.contains(name)) {
            throw new PolicyStoreException("Update:  policy " + pid + " not found");
        }
        if (this.datastreamControlGroup.equals("X")) {
            try {
                this.apiMService.modifyDatastreamByValue(this.getContext(), pid, FESL_POLICY_DATASTREAM, null, null, null, null, (InputStream)new ByteArrayInputStream(newDocument.getBytes("UTF-8")), "DISABLED", null, "Modifying policy " + pid, null);
            }
            catch (Exception e) {
                throw new PolicyStoreException("Update:  error modifying datastream by value for " + pid + " - " + e.getMessage(), e);
            }
        }
        if (this.datastreamControlGroup.equals("M")) {
            String dsLocation = null;
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(newDocument.getBytes("UTF-8"));
                dsLocation = this.apiMService.putTempStream(this.getContext(), (InputStream)is);
            }
            catch (Exception e) {
                throw new PolicyStoreException("Update: error generating temp datastream location - " + e.getMessage(), e);
            }
            try {
                this.apiMService.modifyDatastreamByReference(this.getContext(), pid, FESL_POLICY_DATASTREAM, null, null, null, null, dsLocation, "DISABLED", null, "Modifying policy " + pid, null);
            }
            catch (ServerException e) {
                throw new PolicyStoreException("Update:  error modifying datastream by reference for " + pid + " - " + e.getMessage(), e);
            }
        }
        throw new PolicyStoreException("Update:  Invalid datastream control group " + this.datastreamControlGroup + " - use M or X");
        return true;
    }

    @Override
    public byte[] getPolicy(String name) throws PolicyStoreException {
        String pid = this.getPID(name);
        if (!this.contains(name)) {
            throw new PolicyStoreException("Get: policy " + pid + " does not exist.");
        }
        try {
            InputStream is = this.apiAService.getDatastreamDissemination(this.getContext(), pid, FESL_POLICY_DATASTREAM, null).getStream();
            return IOUtils.toByteArray((InputStream)is);
        }
        catch (Exception e) {
            throw new PolicyStoreException("Get: error reading policy " + pid + " - " + e.getMessage(), e);
        }
    }

    @Override
    public boolean contains(String policyName) throws PolicyStoreException {
        String pid = this.getPID(policyName);
        ObjectProfile objectProfile = null;
        try {
            objectProfile = this.apiAService.getObjectProfile(this.getContext(), pid, null);
        }
        catch (ObjectNotInLowlevelStorageException objectNotInLowlevelStorageException) {
        }
        catch (ServerException e) {
            throw new PolicyStoreException("Add: error getting object profile for " + pid + " - " + e.getMessage(), e);
        }
        if (objectProfile == null) {
            return false;
        }
        return objectProfile.objectState.equals("A") || objectProfile.objectState.equals("I");
    }

    @Override
    public boolean contains(File policy) throws PolicyStoreException {
        try {
            return this.contains(this.utils.getPolicyName(policy));
        }
        catch (MelcoePDPException e) {
            throw new PolicyStoreException(e);
        }
    }

    @Override
    public List<String> listPolicies() throws PolicyStoreException {
        return null;
    }

    private String getPID(String name) throws PolicyStoreException {
        String pid;
        if (name.startsWith(FESL_BOOTSTRAP_POLICY_NAMESPACE + ":")) {
            pid = name;
        } else {
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (FedoraPolicyStore.isAlphaNum(c) || c == '-' || c == '.' || c == '~' || c == '_') {
                    out.append(c);
                    continue;
                }
                out.append("_");
            }
            pid = this.pidNamespace + ":" + out.toString();
        }
        try {
            return PID.normalize((String)pid);
        }
        catch (MalformedPIDException e) {
            throw new PolicyStoreException("Invalid policy name '" + name + "'.  Could not create a valid PID from this name: " + e.getMessage(), e);
        }
    }

    private Context getContext() throws PolicyStoreException {
        try {
            return ReadOnlyContext.getContext(null, (String)"fedoraBootstrap", null, (boolean)false);
        }
        catch (Exception e) {
            throw new PolicyStoreException(e.getMessage(), e);
        }
    }

    private static String getFOXMLPolicyTemplate(String pid, String label, String contentModel, String collection, String collectionRelationship, String policyOrLocation, String controlGroup) throws PolicyStoreException {
        StringBuilder foxml = new StringBuilder(1024);
        foxml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        foxml.append("<foxml:digitalObject VERSION=\"1.1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        foxml.append("    xmlns:foxml=\"info:fedora/fedora-system:def/foxml#\"\n");
        foxml.append("           xsi:schemaLocation=\"" + Constants.FOXML.uri + " " + Constants.FOXML1_1.xsdLocation + "\"");
        foxml.append("\n           PID=\"");
        StreamUtility.enc((String)pid, (StringBuilder)foxml);
        foxml.append("\">\n  <foxml:objectProperties>\n");
        foxml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#state\" VALUE=\"A\"/>\n");
        foxml.append("    <foxml:property NAME=\"info:fedora/fedora-system:def/model#label\" VALUE=\"");
        StreamUtility.enc((String)label, (StringBuilder)foxml);
        foxml.append("\"/>\n  </foxml:objectProperties>\n");
        if (!(pid.startsWith(FESL_BOOTSTRAP_POLICY_NAMESPACE + ":") || contentModel.isEmpty() && collection.isEmpty())) {
            foxml.append("<foxml:datastream ID=\"RELS-EXT\" CONTROL_GROUP=\"X\">");
            foxml.append("<foxml:datastreamVersion FORMAT_URI=\"info:fedora/fedora-system:FedoraRELSExt-1.0\" ID=\"RELS-EXT.0\" MIMETYPE=\"application/rdf+xml\" LABEL=\"RDF Statements about this object\">");
            foxml.append("  <foxml:xmlContent>");
            foxml.append("   <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\" xmlns:rel=\"info:fedora/fedora-system:def/relations-external#\">");
            foxml.append("      <rdf:Description rdf:about=\"info:fedora/");
            StreamUtility.enc((String)pid, (StringBuilder)foxml);
            foxml.append("\">");
            if (!contentModel.isEmpty()) {
                foxml.append("        <fedora-model:hasModel rdf:resource=\"");
                StreamUtility.enc((String)contentModel, (StringBuilder)foxml);
                foxml.append("\"/>");
            }
            if (!collection.isEmpty()) {
                foxml.append("        <rel:");
                StreamUtility.enc((String)collectionRelationship, (StringBuilder)foxml);
                foxml.append(" rdf:resource=\"");
                StreamUtility.enc((String)collection, (StringBuilder)foxml);
                foxml.append("\"/>");
            }
            foxml.append("       </rdf:Description>");
            foxml.append("      </rdf:RDF>");
            foxml.append("    </foxml:xmlContent>");
            foxml.append("  </foxml:datastreamVersion>");
            foxml.append("</foxml:datastream>");
        }
        foxml.append("<foxml:datastream ID=\"FESLPOLICY\" CONTROL_GROUP=\"" + controlGroup + "\">");
        foxml.append("<foxml:datastreamVersion ID=\"POLICY.0\" MIMETYPE=\"text/xml\" LABEL=\"XACML policy datastream\">");
        if (controlGroup.equals("M")) {
            foxml.append("  <foxml:contentLocation REF=\"" + policyOrLocation + "\" TYPE=\"" + "URL" + "\"/>");
        } else if (controlGroup.equals("X")) {
            foxml.append("  <foxml:xmlContent>");
            foxml.append(policyOrLocation);
            foxml.append("    </foxml:xmlContent>");
        } else {
            throw new PolicyStoreException("Generating new object XML:  Invalid control group: " + controlGroup + " - use X or M.");
        }
        foxml.append("  </foxml:datastreamVersion>");
        foxml.append("</foxml:datastream>");
        foxml.append("</foxml:digitalObject>");
        return foxml.toString();
    }

    private static boolean isAlphaNum(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }
}

