/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.pdp.data;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.security.xacml.pdp.MelcoePDP;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndex;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexBase;
import org.fcrepo.server.security.xacml.pdp.data.PolicyIndexException;
import org.fcrepo.server.security.xacml.pdp.finder.policy.PolicyReader;
import org.fcrepo.server.security.xacml.util.DataFileUtils;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FilePolicyIndex
extends PolicyIndexBase
implements PolicyIndex {
    private static final Logger logger = LoggerFactory.getLogger((String)FilePolicyIndex.class.getName());
    private String DB_HOME = null;
    private static Map<String, byte[]> policies = null;
    private static final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    public static final Lock readLock = rwl.readLock();
    public static final Lock writeLock = rwl.writeLock();

    protected FilePolicyIndex(PolicyReader policyReader) throws PolicyIndexException {
        super(policyReader);
        this.indexed = false;
        logger.info("Starting FilePolicyIndex");
    }

    public void setPolicyDirectoryPath(String dbHome) throws PolicyIndexException {
        if (logger.isDebugEnabled()) {
            Runtime runtime = Runtime.getRuntime();
            logger.debug("Total memory: " + runtime.totalMemory() / 1024L);
            logger.debug("Free memory: " + runtime.freeMemory() / 1024L);
            logger.debug("Max memory: " + runtime.maxMemory() / 1024L);
        }
        this.DB_HOME = MelcoePDP.PDP_HOME.getAbsolutePath() + dbHome;
        File db_home = new File(this.DB_HOME);
        if (!db_home.exists()) {
            try {
                db_home.mkdirs();
            }
            catch (Exception e) {
                throw new PolicyIndexException("Could not create DB directory: " + db_home.getAbsolutePath());
            }
        }
    }

    public void init() throws PolicyIndexException {
        this.loadPolicies(this.DB_HOME);
    }

    @Override
    public Map<String, AbstractPolicy> getPolicies(EvaluationCtx eval, PolicyFinder policyFinder) throws PolicyIndexException {
        readLock.lock();
        try {
            ConcurrentHashMap<String, AbstractPolicy> result = new ConcurrentHashMap<String, AbstractPolicy>();
            for (String id : policies.keySet()) {
                AbstractPolicy policy = this.handleDocument(this.m_policyReader.readPolicy(policies.get(id)), policyFinder);
                result.put(id, policy);
            }
            ConcurrentHashMap<String, AbstractPolicy> concurrentHashMap = result;
            return concurrentHashMap;
        }
        catch (ParsingException pe) {
            throw new PolicyIndexException(pe.getMessage(), pe);
        }
        finally {
            readLock.unlock();
        }
    }

    private File nameToFile(String policyName) throws PolicyIndexException {
        PID pid;
        try {
            pid = new PID(policyName);
        }
        catch (MalformedPIDException e) {
            throw new PolicyIndexException("Invalid policy name.  Policy name must be a valid PID - " + policyName);
        }
        return new File(this.DB_HOME + "/" + pid.toFilename() + ".xml");
    }

    private String fileToName(File policyFile) throws PolicyIndexException {
        try {
            if (!policyFile.getName().endsWith(".xml")) {
                throw new PolicyIndexException("Invalid policy file name.  Policy files must end in .xml - " + policyFile.getName());
            }
            return PID.fromFilename((String)policyFile.getName().substring(0, policyFile.getName().lastIndexOf(".xml"))).toString();
        }
        catch (MalformedPIDException e) {
            throw new PolicyIndexException("Invalid policy file name.  Filename cannot be converted to a valid PID - " + policyFile.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addPolicy(String name, String document) throws PolicyIndexException {
        writeLock.lock();
        try {
            logger.debug("Adding policy named: " + name);
            String string = this.doAdd(name, document);
            return string;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean deletePolicy(String name) throws PolicyIndexException {
        writeLock.lock();
        try {
            logger.debug("Deleting policy named: " + name);
            boolean bl = this.doDelete(name);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePolicy(String name, String newDocument) throws PolicyIndexException {
        writeLock.lock();
        try {
            logger.debug("Updating policy named: " + name);
            if (this.doDelete(name)) {
                this.doAdd(name, newDocument);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    private String doAdd(String name, String document) throws PolicyIndexException {
        String filename = this.nameToFile(name).getAbsolutePath();
        if (policies.put(name, document.getBytes()) != null) {
            throw new PolicyIndexException("Attempting to add policy " + name + " but it already exists");
        }
        try {
            logger.debug("Saving policy file in index: " + filename);
            DataFileUtils.saveDocument(filename, document.getBytes());
        }
        catch (Exception e) {
            throw new PolicyIndexException("Failed to save policy file " + filename);
        }
        return name;
    }

    private boolean doDelete(String name) throws PolicyIndexException {
        if (policies.remove(name) == null) {
            throw new PolicyIndexException("Attempting to delete non-existent policy " + name);
        }
        File policy = this.nameToFile(name);
        logger.debug("Removing policy file from index: " + policy);
        if (!policy.exists()) {
            logger.error("Policy " + name + " removed from cache, but no corresponding file found in policy cache directory");
        } else if (!policy.delete()) {
            policy.deleteOnExit();
            logger.error("Failed to delete policy file " + policy.getName() + ".  Marked for deletion on VM exit");
        }
        return true;
    }

    @Override
    public AbstractPolicy getPolicy(String name, PolicyFinder policyFinder) throws PolicyIndexException {
        readLock.lock();
        try {
            logger.debug("Getting policy named: " + name);
            if (policies.containsKey(name)) {
                AbstractPolicy abstractPolicy = this.handleDocument(this.m_policyReader.readPolicy(policies.get(name)), policyFinder);
                return abstractPolicy;
            }
            try {
                throw new PolicyIndexException("Attempting to get non-existent policy " + name);
            }
            catch (ParsingException pe) {
                throw new PolicyIndexException(pe.getMessage(), pe);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public boolean contains(String name) throws PolicyIndexException {
        readLock.lock();
        try {
            boolean bl = policies.containsKey(name);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear() throws PolicyIndexException {
        writeLock.lock();
        try {
            logger.debug("Clearing file policy index");
            File policyDir = new File(this.DB_HOME);
            for (File policyFile : policyDir.listFiles()) {
                if (policyFile.delete()) continue;
                throw new PolicyIndexException("Could not clear policy index.  Failed to delete policy file " + policyFile.getAbsolutePath());
            }
            policies = new ConcurrentHashMap<String, byte[]>();
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPolicies(String policyDir) throws PolicyIndexException {
        writeLock.lock();
        try {
            if (policies == null) {
                File[] pf;
                logger.info("Populating FeSL File policy index cache from " + policyDir);
                policies = new ConcurrentHashMap<String, byte[]>();
                File policyHome = new File(policyDir);
                if (!policyHome.exists()) {
                    throw new PolicyIndexException("Policy directory does not exist: " + policyHome.getAbsolutePath());
                }
                for (File f : pf = policyHome.listFiles()) {
                    if (!f.getName().endsWith(".xml")) {
                        throw new PolicyIndexException("Non .xml files found in policy index cache directory");
                    }
                    try {
                        logger.info("Loading FeSL policy from cache directory: " + f.getAbsolutePath());
                        byte[] doc = DataFileUtils.loadFile(f);
                        String policyName = this.fileToName(f);
                        logger.debug("Adding policy file to cache, policy name: " + policyName);
                        policies.put(policyName, doc);
                    }
                    catch (Exception e) {
                        logger.error("Error loading document: " + f.getName(), (Throwable)e);
                        throw new PolicyIndexException("Error loading document: " + f.getName(), e);
                    }
                }
                logger.info("Populated cache with " + pf.length + " files");
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

