/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fcrepo.server.security.xacml.pdp.finder.AttributeFinderException;
import org.fcrepo.server.security.xacml.util.Designator;

public class AttributeFinderConfig {
    private final Map<Integer, Designator> designators = new HashMap<Integer, Designator>();

    public Designator get(int designator) {
        return this.designators.get(designator);
    }

    public Designator get(String designatorName) {
        return this.designators.get(AttributeFinderConfig.getTarget(designatorName));
    }

    public Set<Integer> getDesignatorIds() {
        return this.designators.keySet();
    }

    public Designator put(String designatorName) throws AttributeFinderException {
        int target = AttributeFinderConfig.getTarget(designatorName);
        if (target != -1) {
            Designator des = this.designators.get(target);
            if (des == null) {
                des = new Designator();
            }
            this.designators.put(target, des);
            return des;
        }
        throw new AttributeFinderException("Invalid attribute designator name " + designatorName);
    }

    private static Integer getTarget(String targetName) {
        if (targetName.equals("resource")) {
            return 1;
        }
        if (targetName.equals("subject")) {
            return 0;
        }
        if (targetName.equals("environment")) {
            return 3;
        }
        if (targetName.equals("action")) {
            return 2;
        }
        return -1;
    }
}

