/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fcrepo.common.Constants;
import org.fcrepo.server.security.Attribute;
import org.fcrepo.server.security.RequestCtx;
import org.fcrepo.server.security.impl.BasicAttribute;
import org.fcrepo.server.security.impl.BasicRequestCtx;
import org.fcrepo.server.security.impl.SingletonAttribute;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.attr.AnyURIAttribute;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.StringAttribute;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextUtil {
    private static final Logger logger = LoggerFactory.getLogger(ContextUtil.class);
    private final Map<URI, URI> actionMap = new ConcurrentHashMap<URI, URI>();
    private final Map<String, String> actionValueMap = new ConcurrentHashMap<String, String>();

    public ContextUtil() {
        logger.info("created");
    }

    public void setActionMap(Map<String, String> actions) {
        for (String from : actions.keySet()) {
            String to = actions.get(from);
            try {
                URI key = new URI(from);
                URI value = new URI(actions.get(from));
                this.actionMap.put(key, value);
            }
            catch (URISyntaxException e) {
                logger.warn("Mapping contained invalid URI: [" + from + "] / [" + to + "]");
            }
        }
    }

    public void setActionValueMap(Map<String, String> values) {
        this.actionValueMap.putAll(values);
    }

    public List<Subject> setupSubjects(List<Map<URI, List<AttributeValue>>> subjs) {
        if (subjs == null || subjs.size() == 0) {
            return Collections.singletonList(new Subject(new ArrayList()));
        }
        ArrayList<Subject> subjects = new ArrayList<Subject>(subjs.size());
        for (Map<URI, List<AttributeValue>> s : subjs) {
            ArrayList<BasicAttribute> attributes = new ArrayList<BasicAttribute>();
            for (URI uri : s.keySet()) {
                List<AttributeValue> attributeValues = s.get(uri);
                if (attributeValues == null || attributeValues.size() <= 0) continue;
                attributes.add(new BasicAttribute(uri, attributeValues.get(0).getType(), null, null, attributeValues));
            }
            subjects.add(new Subject(attributes));
        }
        return subjects;
    }

    public List<Attribute> setupResources(Map<URI, AttributeValue> res, RelationshipResolver relationshipResolver) throws MelcoeXacmlException {
        if (res == null || res.size() == 0) {
            return new ArrayList<Attribute>();
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(res.size());
        try {
            String pid = null;
            AttributeValue pidAttr = res.get(Constants.XACML1_RESOURCE.ID.attributeId);
            if (pidAttr != null) {
                pid = pidAttr.encode();
                pid = relationshipResolver.buildRESTParentHierarchy(pid);
                String dsid = null;
                AttributeValue dsidAttr = res.get(Constants.DATASTREAM.ID.attributeId);
                if (dsidAttr != null && !(dsid = dsidAttr.encode()).isEmpty()) {
                    pid = pid + "/" + dsid;
                }
                res.put(Constants.XACML1_RESOURCE.ID.attributeId, (AttributeValue)new AnyURIAttribute(new URI(pid)));
            }
        }
        catch (Exception e) {
            logger.error("Error finding parents.", (Throwable)e);
            throw new MelcoeXacmlException("Error finding parents.", e);
        }
        for (URI uri : res.keySet()) {
            attributes.add((Attribute)new SingletonAttribute(uri, null, null, res.get(uri)));
        }
        return attributes;
    }

    public List<Attribute> setupAction(Map<URI, AttributeValue> a) {
        if (a == null || a.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> actions = new ArrayList<Attribute>(a.size());
        HashMap<URI, AttributeValue> newActions = new HashMap<URI, AttributeValue>();
        for (URI uri : a.keySet()) {
            String tmpValue;
            URI newUri = null;
            AttributeValue newValue = null;
            if (this.actionMap != null && this.actionMap.size() > 0) {
                newUri = this.actionMap.get(uri);
            }
            if (this.actionValueMap != null && this.actionValueMap.size() > 0 && (tmpValue = this.actionValueMap.get(a.get(uri).encode())) != null) {
                newValue = new StringAttribute(tmpValue);
            }
            newUri = newUri == null ? uri : newUri;
            newValue = newValue == null ? a.get(uri) : newValue;
            newActions.put(newUri, newValue);
        }
        for (URI uri : newActions.keySet()) {
            actions.add((Attribute)new SingletonAttribute(uri, null, null, (AttributeValue)newActions.get(uri)));
        }
        return actions;
    }

    public List<Attribute> setupEnvironment(Map<URI, AttributeValue> e) {
        if (e == null || e.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> environment = new ArrayList<Attribute>(e.size());
        for (URI uri : e.keySet()) {
            environment.add((Attribute)new SingletonAttribute(uri, null, null, e.get(uri)));
        }
        return environment;
    }

    public RequestCtx buildRequest(List<Map<URI, List<AttributeValue>>> subjects, Map<URI, AttributeValue> actions, Map<URI, AttributeValue> resources, Map<URI, AttributeValue> environment, RelationshipResolver relationshipResolver) throws MelcoeXacmlException {
        logger.debug("Building request!");
        BasicRequestCtx request = null;
        try {
            request = new BasicRequestCtx(this.setupSubjects(subjects), this.setupResources(resources, relationshipResolver), this.setupAction(actions), this.setupEnvironment(environment));
        }
        catch (Exception e) {
            logger.error("Error creating request.", (Throwable)e);
            throw new MelcoeXacmlException("Error creating request", e);
        }
        return request;
    }

    public ResponseCtx makeResponseCtx(String response) throws MelcoeXacmlException {
        ResponseCtx resCtx = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(response.getBytes());
            resCtx = ResponseCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return resCtx;
    }

    public RequestCtx makeRequestCtx(String request) throws MelcoeXacmlException {
        RequestCtx reqCtx = null;
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(request.getBytes());
            reqCtx = BasicRequestCtx.getInstance((InputStream)is);
        }
        catch (ParsingException pe) {
            throw new MelcoeXacmlException("Error parsing response.", pe);
        }
        return reqCtx;
    }

    public String makeRequestCtx(RequestCtx reqCtx) {
        ByteArrayOutputStream request = new ByteArrayOutputStream();
        reqCtx.encode((OutputStream)request, new Indenter());
        return new String(request.toByteArray());
    }

    public String makeResponseCtx(ResponseCtx resCtx) {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        resCtx.encode((OutputStream)response, new Indenter());
        return new String(response.toByteArray());
    }

    public Map<String, Result> makeResultMap(ResponseCtx resCtx) {
        Iterator i = resCtx.getResults().iterator();
        HashMap<String, Result> resultMap = new HashMap<String, Result>();
        while (i.hasNext()) {
            Result r = (Result)i.next();
            resultMap.put(r.getResource(), r);
        }
        return resultMap;
    }
}

