/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security.xacml.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.common.MalformedPIDException;
import org.fcrepo.common.PID;
import org.fcrepo.server.Server;
import org.fcrepo.server.resourceIndex.ResourceIndex;
import org.fcrepo.server.security.xacml.MelcoeXacmlException;
import org.fcrepo.server.security.xacml.util.RelationshipResolver;
import org.fcrepo.server.security.xacml.util.RelationshipResolverBase;
import org.jrdf.graph.Node;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;
import org.jrdf.graph.Triple;
import org.jrdf.graph.URIReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.trippi.TripleIterator;
import org.trippi.TripleMaker;
import org.trippi.TrippiException;
import org.trippi.TupleIterator;

public class RIRelationshipResolver
extends RelationshipResolverBase
implements RelationshipResolver {
    private static final Logger logger = LoggerFactory.getLogger(RIRelationshipResolver.class);
    private final ResourceIndex RI;
    private boolean spoTriples = false;
    private boolean sparqlTuples = false;
    private boolean itqlTuples = false;
    protected List<String> tripleLanguages;
    protected List<String> tupleLanguages;
    private static final String SPO = "spo";
    private static final String SPARQL = "sparql";
    private static final String ITQL = "itql";

    public RIRelationshipResolver(Server server, Map<String, String> options) throws MelcoeXacmlException {
        super(options);
        try {
            this.RI = (ResourceIndex)server.getModule("org.fcrepo.server.resourceIndex.ResourceIndex");
        }
        catch (Exception e) {
            throw new MelcoeXacmlException("Error getting resource index.", e);
        }
        if (this.RI == null) {
            throw new MelcoeXacmlException("No Resource Index Module is available to the Server.");
        }
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject) throws MelcoeXacmlException {
        return this.getRelationships(subject, null);
    }

    @Override
    public Map<String, Set<String>> getRelationships(String subject, String relationship) throws MelcoeXacmlException {
        URIReference p;
        URIReference s;
        HashMap<String, Set<String>> rels = new HashMap<String, Set<String>>();
        if (subject == null) {
            logger.warn("Subject cannot be null");
            return rels;
        }
        try {
            s = TripleMaker.createResource((String)this.getFedoraResourceURI(subject));
            p = relationship != null ? TripleMaker.createResource((String)relationship) : null;
        }
        catch (TrippiException e) {
            throw new MelcoeXacmlException("Error creating nodes for trippi query " + e.getMessage(), e);
        }
        try {
            TripleIterator it = this.RI.findTriples((SubjectNode)s, (PredicateNode)p, null, 0);
            while (it.hasNext()) {
                Triple t = it.next();
                String pred = t.getPredicate().toString();
                HashSet<String> values = (HashSet<String>)rels.get(pred);
                if (values == null) {
                    values = new HashSet<String>();
                }
                values.add(t.getObject().stringValue());
                rels.put(pred, values);
            }
        }
        catch (TrippiException e) {
            throw new MelcoeXacmlException("Error finding relationships " + e.getMessage(), e);
        }
        return rels;
    }

    protected Map<String, Set<String>> getReverseRelationships(String object) throws MelcoeXacmlException {
        return this.getReverseRelationships(object, null);
    }

    protected Map<String, Set<String>> getReverseRelationships(String object, String relationship) throws MelcoeXacmlException {
        URIReference p;
        URIReference o;
        HashMap<String, Set<String>> rels = new HashMap<String, Set<String>>();
        if (object == null) {
            logger.warn("Object cannot be null");
            return rels;
        }
        try {
            o = TripleMaker.createResource((String)this.getFedoraResourceURI(object));
            p = relationship != null ? TripleMaker.createResource((String)relationship) : null;
        }
        catch (TrippiException e) {
            throw new MelcoeXacmlException("Error creating nodes for trippi query " + e.getMessage(), e);
        }
        try {
            TripleIterator it = this.RI.findTriples(null, (PredicateNode)p, (ObjectNode)o, 0);
            while (it.hasNext()) {
                Triple t = it.next();
                String pred = t.getPredicate().toString();
                HashSet<String> values = (HashSet<String>)rels.get(pred);
                if (values == null) {
                    values = new HashSet<String>();
                }
                values.add(t.getSubject().stringValue());
                rels.put(pred, values);
            }
        }
        catch (TrippiException e) {
            throw new MelcoeXacmlException("Error finding relationships " + e.getMessage(), e);
        }
        return rels;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<String> getAttributesFromQuery(String query, String queryLang, String variable) throws MelcoeXacmlException {
        HashSet<String> res = new HashSet<String>();
        if (queryLang.equals("tql")) {
            queryLang = ITQL;
        }
        if (queryLang.equals(ITQL) || queryLang.equals(SPARQL)) {
            if (!this.verifyTupleLanguage(queryLang)) {
                logger.warn("RI query language " + queryLang + " is not supported");
                return res;
            }
            try {
                TupleIterator tuples = this.RI.findTuples(queryLang, query, 0, true);
                if (tuples == null) return res;
                while (tuples.hasNext()) {
                    Map tuple = tuples.next();
                    Node variableValue = (Node)tuple.get(variable);
                    if (variableValue != null) {
                        res.add(variableValue.stringValue());
                        continue;
                    }
                    logger.error("Attribute query does not contain a result variable " + variable);
                    return res;
                }
                return res;
            }
            catch (TrippiException e) {
                logger.error("Error running " + queryLang + " query " + query + " : " + e.getMessage(), (Throwable)e);
            }
            return res;
        }
        if (queryLang.equals(SPO)) {
            if (!this.spoTriples && !this.verifyTripleLanguage(queryLang)) {
                logger.warn("RI query language " + queryLang + " is not supported");
                return res;
            }
            if (variable.length() == 1 && SPO.contains(variable)) {
                try {
                    TripleIterator triples = this.RI.findTriples(queryLang, query, 0, true);
                    if (triples == null) return res;
                    while (triples.hasNext()) {
                        Triple triple = triples.next();
                        switch (variable.charAt(0)) {
                            case 's': {
                                res.add(triple.getSubject().stringValue());
                                break;
                            }
                            case 'p': {
                                res.add(triple.getPredicate().stringValue());
                                break;
                            }
                            case 'o': {
                                res.add(triple.getObject().stringValue());
                            }
                        }
                    }
                    return res;
                }
                catch (TrippiException e) {
                    logger.error("Error running " + queryLang + " query " + query + " : " + e.getMessage(), (Throwable)e);
                    return res;
                }
            } else {
                logger.error("spo query must specify s, p or o as output variable binding");
            }
            return res;
        } else {
            logger.error("Query language not supported: " + queryLang);
        }
        return res;
    }

    @Override
    public String buildRESTParentHierarchy(String pid) throws MelcoeXacmlException {
        Set<String> parents = this.getParents(pid);
        if (parents == null || parents.size() == 0) {
            return "/" + pid;
        }
        String[] parentArray = parents.toArray(new String[parents.size()]);
        return this.buildRESTParentHierarchy(parentArray[0]) + "/" + pid;
    }

    protected String getTQLQuery(String pidUri) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("select $parent from <#ri> where ");
        sb.append("(");
        sb.append("<" + pidUri + "> $rel1 $parent ");
        sb.append(" and (");
        for (i = 0; i < this.parentRelationships.size(); ++i) {
            if (i > 0) {
                sb.append(" or ");
            }
            sb.append("$rel1 <http://mulgara.org/mulgara#is> <" + (String)this.parentRelationships.get(i) + "> ");
        }
        sb.append(")");
        sb.append(")");
        if (this.parentRelationships != null && !this.parentRelationships.isEmpty()) {
            sb.append(" or (");
            sb.append("$parent $rel2 <" + pidUri + "> ");
            sb.append(" and (");
            for (i = 0; i < this.childRelationships.size(); ++i) {
                if (i > 0) {
                    sb.append(" or ");
                }
                sb.append("$rel2 <http://mulgara.org/mulgara#is> <" + (String)this.childRelationships.get(i) + "> ");
            }
            sb.append(")");
            sb.append(")");
        }
        return sb.toString();
    }

    protected String getSPARQLQuery(String pidUri) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ?parent FROM <#ri> WHERE ");
        sb.append(" { ");
        for (i = 0; i < this.parentRelationships.size(); ++i) {
            if (i > 0) {
                sb.append(" UNION ");
            }
            sb.append(" { ");
            sb.append(" <" + pidUri + "> <" + (String)this.parentRelationships.get(i) + "> ?parent.");
            sb.append(" } ");
        }
        if (this.childRelationships != null && !this.childRelationships.isEmpty()) {
            for (i = 0; i < this.childRelationships.size(); ++i) {
                sb.append(" UNION ");
                sb.append(" { ");
                sb.append(" ?parent  <" + (String)this.parentRelationships.get(i) + "> <" + pidUri + ">.");
                sb.append(" } ");
            }
        }
        sb.append(" } ");
        return sb.toString();
    }

    protected Set<String> getParents(String pid) throws MelcoeXacmlException {
        logger.debug("Obtaining parents for: {}", (Object)pid);
        HashSet<String> parentPIDs = new HashSet<String>();
        if (pid.equalsIgnoreCase(Constants.FEDORA_REPOSITORY_PID.uri)) {
            return parentPIDs;
        }
        String pidUri = this.getFedoraResourceURI(pid);
        if (this.verifyTupleLanguage(ITQL) || this.verifyTupleLanguage(SPARQL)) {
            String query = "";
            String lang = "";
            if (this.itqlTuples) {
                lang = ITQL;
                query = this.getTQLQuery(pidUri);
            } else if (this.sparqlTuples) {
                lang = SPARQL;
                query = this.getSPARQLQuery(pidUri);
            } else {
                throw new MelcoeXacmlException("RI supports no expected query languages for parent queries.");
            }
            logger.debug("{} query: {}", (Object)lang, (Object)query);
            try {
                TupleIterator tuples = this.RI.findTuples(lang, query, 0, false);
                if (tuples != null) {
                    while (tuples.hasNext()) {
                        Node parent = (Node)tuples.next().get("parent");
                        if (parent != null) {
                            if (parent.isURIReference()) {
                                try {
                                    PID parentPID = new PID(parent.stringValue());
                                    logger.debug("Found parent " + parentPID.toString());
                                    parentPIDs.add(parentPID.toString());
                                }
                                catch (MalformedPIDException e) {
                                    logger.warn("parent/child relationship target is not a Fedora object" + parent.stringValue());
                                }
                                continue;
                            }
                            logger.warn("parent/child query result is not a Fedora object " + parent.stringValue());
                            continue;
                        }
                        logger.error("parent/child tuple result did not contain parent variable");
                    }
                    logger.debug("Query result count: " + tuples.count());
                }
                logger.debug("Query returned 0 results");
            }
            catch (TrippiException e) {
                logger.error("Error running TQL query " + e.getMessage(), (Throwable)e);
                return parentPIDs;
            }
        } else if (this.spoTriples || this.verifyTripleLanguage(SPO)) {
            Map<String, Set<String>> pRels = null;
            pRels = this.parentRelationships.size() == 1 ? this.getRelationships(pidUri, (String)this.parentRelationships.get(0)) : this.getRelationships(pidUri);
            for (String rel : pRels.keySet()) {
                if (!this.parentRelationships.contains(rel)) continue;
                for (String parent : pRels.get(rel)) {
                    try {
                        PID parentPid = new PID(parent);
                        parentPIDs.add(parentPid.toString());
                    }
                    catch (MalformedPIDException e) {
                        logger.warn("Parent of " + pid + " through relationship " + rel + " is not a Fedora resource");
                    }
                }
            }
            if (this.childRelationships != null && !this.childRelationships.isEmpty()) {
                Map<String, Set<String>> cRels = null;
                cRels = this.childRelationships.size() == 1 ? this.getReverseRelationships(pidUri, (String)this.childRelationships.get(0)) : this.getReverseRelationships(pidUri);
                for (String rel : cRels.keySet()) {
                    if (!this.childRelationships.contains(rel)) continue;
                    for (String parent : cRels.get(rel)) {
                        try {
                            PID parentPid = new PID(parent);
                            parentPIDs.add(parentPid.toString());
                        }
                        catch (MalformedPIDException e) {
                            logger.warn("Parent of " + pid + " through relationship " + rel + " is not a Fedora resource");
                        }
                    }
                }
            }
        } else {
            logger.error("Can't get parents: Resource index implementation must support SPARQL tuple queries or SPO triple queries");
            return parentPIDs;
        }
        return parentPIDs;
    }

    private boolean verifyTripleLanguage(String lang) {
        if (this.tripleLanguages == null) {
            this.tripleLanguages = Arrays.asList(this.RI.listTripleLanguages());
            this.spoTriples = this.tripleLanguages.contains(SPO);
        }
        return this.tripleLanguages.contains(lang);
    }

    private boolean verifyTupleLanguage(String lang) {
        if (this.tupleLanguages == null) {
            this.tupleLanguages = Arrays.asList(this.RI.listTupleLanguages());
            this.sparqlTuples = this.tupleLanguages.contains(SPARQL);
            this.itqlTuples = this.tupleLanguages.contains(ITQL);
        }
        return this.tupleLanguages.contains(lang);
    }
}

