/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.FedoraObject;
import org.fcrepo.serialization.BaseFedoraObjectSerializer;
import org.springframework.stereotype.Component;

@Component
public class JcrXmlSerializer
extends BaseFedoraObjectSerializer {
    @Override
    public String getKey() {
        return "jcr/xml";
    }

    @Override
    public String getMediaType() {
        return "application/xml";
    }

    @Override
    public void serialize(FedoraObject fedoraObject, OutputStream outputStream) throws RepositoryException, IOException {
        Node node = fedoraObject.getNode();
        node.getSession().exportSystemView(node.getPath(), outputStream, false, false);
    }

    @Override
    public void deserialize(Session session, String string, InputStream inputStream) throws RepositoryException, IOException {
        session.importXML(string, inputStream, 3);
    }
}

