/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.serialization;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.fcrepo.serialization.FedoraObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class SerializerUtil
implements ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializerUtil.class);
    private ApplicationContext applicationContext;
    private Map<String, FedoraObjectSerializer> serializerMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Set<String> keySet() {
        return this.getFedoraObjectSerializers().keySet();
    }

    public FedoraObjectSerializer getSerializer(String format) {
        return this.getFedoraObjectSerializers().get(format);
    }

    public Map<String, FedoraObjectSerializer> getFedoraObjectSerializers() {
        return this.serializerMap;
    }

    @PostConstruct
    public void buildFedoraObjectSerializersMap() {
        Map beans = this.applicationContext.getBeansOfType(FedoraObjectSerializer.class);
        HashMap<String, FedoraObjectSerializer> m = new HashMap<String, FedoraObjectSerializer>();
        for (Map.Entry e : beans.entrySet()) {
            FedoraObjectSerializer serializer = (FedoraObjectSerializer)e.getValue();
            LOGGER.info("Registering serializer {} for format {}", (Object)serializer, (Object)serializer.getKey());
            m.put(serializer.getKey(), serializer);
        }
        this.serializerMap = m;
    }
}

