/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.serialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.serialization.BaseFedoraObjectSerializer;
import org.fcrepo.serialization.InvalidSerializationFormatException;
import org.springframework.stereotype.Component;

@Component
public class JcrXmlSerializer
extends BaseFedoraObjectSerializer {
    @Override
    public String getKey() {
        return "jcr/xml";
    }

    @Override
    public String getMediaType() {
        return "application/xml";
    }

    @Override
    public boolean canSerialize(FedoraResource resource) {
        return !resource.hasType("fedora:Binary") && !resource.hasType("fedora:NonRdfSourceDescription") && !resource.isFrozenResource();
    }

    @Override
    public void serialize(FedoraResource obj, OutputStream out, boolean skipBinary, boolean recurse) throws RepositoryException, IOException, InvalidSerializationFormatException {
        if (obj.hasType("fedora:Binary")) {
            throw new InvalidSerializationFormatException("Cannot serialize decontextualized binary content.");
        }
        if (obj.isFrozenResource()) {
            throw new InvalidSerializationFormatException("Cannot serialize historic versions.");
        }
        Node node = obj.getNode();
        node.getSession().exportSystemView(obj.getPath(), out, skipBinary, !recurse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserialize(Session session, String path, InputStream stream) throws RepositoryException, IOException, InvalidSerializationFormatException {
        File temp = File.createTempFile("fcrepo-unsanitized-input", ".xml");
        FileOutputStream fos = new FileOutputStream(temp);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)fos);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
            IOUtils.closeQuietly((OutputStream)fos);
        }
        this.validateJCRXML(temp);
        try (TempFileInputStream tmpInputStream = new TempFileInputStream(temp);){
            session.importXML(path, (InputStream)tmpInputStream, 3);
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new InvalidSerializationFormatException("Invalid JCR/XML." + (e.getMessage() != null ? " (" + e.getMessage() + ")" : ""));
        }
    }

    private void validateJCRXML(File file) throws InvalidSerializationFormatException, IOException {
        int depth = 0;
        try (FileInputStream fis = new FileInputStream(file);){
            XMLEventReader reader = XMLInputFactory.newFactory().createXMLEventReader(fis);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    Attribute nameAttribute = startElement.getAttributeByName(new QName("http://www.jcp.org/jcr/sv/1.0", "name"));
                    if (++depth == 1 && nameAttribute != null && "jcr:content".equals(nameAttribute.getValue())) {
                        throw new InvalidSerializationFormatException("Cannot import JCR/XML starting with content node.");
                    }
                    if (depth == 1 && nameAttribute != null && "jcr:frozenNode".equals(nameAttribute.getValue())) {
                        throw new InvalidSerializationFormatException("Cannot import historic versions.");
                    }
                    QName name = startElement.getName();
                    if (name.getNamespaceURI().equals("http://www.jcp.org/jcr/sv/1.0") && (name.getLocalPart().equals("node") || name.getLocalPart().equals("property") || name.getLocalPart().equals("value"))) continue;
                    throw new InvalidSerializationFormatException("Unrecognized element \"" + name.toString() + "\", in import XML.");
                }
                if (!event.isEndElement()) continue;
                --depth;
            }
            reader.close();
        }
        catch (XMLStreamException e) {
            throw new InvalidSerializationFormatException("Unable to parse XML" + (e.getMessage() != null ? " (" + e.getMessage() + ")." : "."));
        }
    }

    private static final class TempFileInputStream
    extends FileInputStream {
        private File f;

        public TempFileInputStream(File f) throws FileNotFoundException {
            super(f);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.f != null) {
                    this.f.delete();
                    this.f = null;
                }
            }
        }
    }
}

