/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities.rebuild.cli;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class CLILoader
extends URLClassLoader {
    public CLILoader(URL[] paths) {
        super(paths);
    }

    public CLILoader(URL[] paths, ClassLoader parent) {
        super(paths, parent);
    }

    public static void main(String[] args) {
        try {
            File webInfLibDir;
            String webInfLib;
            if (args.length == 0) {
                System.err.println("No main class specified.");
                System.err.println("usage: CLILoader <fedora main class> <options>");
                System.exit(1);
            }
            if ((webInfLib = System.getProperty("fedora.web.inf.lib")) == null) {
                System.err.println("fedora.web.inf.lib not defined");
                System.exit(1);
            }
            if (!(webInfLibDir = new File(webInfLib)).exists()) {
                System.err.println("path specified by fedora.web.inf.lib doesn't exist");
                System.exit(1);
            }
            if (!webInfLibDir.isDirectory()) {
                System.err.println("path specified by fedora.web.inf.lib not a directory");
                System.exit(1);
            }
            String[] paths = webInfLibDir.list();
            URL[] urls = new URL[paths.length];
            for (int i = 0; i < paths.length; ++i) {
                urls[i] = new File(webInfLibDir, paths[i]).toURI().toURL();
            }
            CLILoader loader = new CLILoader(urls);
            Thread.currentThread().setContextClassLoader(loader);
            Class<?> rebuild = loader.findClass(args[0]);
            Method main = rebuild.getMethod("main", String[].class);
            String[] modArgs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, modArgs, 0, modArgs.length);
            }
            main.invoke(rebuild, new Object[]{modArgs});
        }
        catch (Exception e) {
            System.err.println("Error executing main class: " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

