/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import javanet.staxutils.IndentingXMLEventWriter;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.fcrepo.server.journal.readerwriter.multicast.Transport;
import org.fcrepo.server.journal.readerwriter.multicast.TransportOutputFile;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;

public class LocalDirectoryTransport
extends Transport {
    public static final String PARAMETER_DIRECTORY_PATH = "directoryPath";
    private final File directory;
    private TransportOutputFile journalFile;
    private XMLEventWriter xmlWriter;

    public LocalDirectoryTransport(Map<String, String> parameters, boolean crucial, TransportParent parent) throws JournalException {
        super(parameters, crucial, parent);
        this.directory = ParameterHelper.parseParametersForWritableDirectory(parameters, (String)PARAMETER_DIRECTORY_PATH);
    }

    @Override
    public void openFile(String repositoryHash, String filename, Date currentDate) throws JournalException {
        try {
            super.testStateChange(Transport.State.FILE_OPEN);
            this.journalFile = new TransportOutputFile(this.directory, filename);
            this.xmlWriter = new IndentingXMLEventWriter(XMLOutputFactory.newInstance().createXMLEventWriter(this.journalFile.open()));
            this.parent.writeDocumentHeader(this.xmlWriter, repositoryHash, currentDate);
            super.setState(Transport.State.FILE_OPEN);
        }
        catch (FactoryConfigurationError e) {
            throw new JournalException(e);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public XMLEventWriter getWriter() throws JournalException {
        super.testWriterState();
        return this.xmlWriter;
    }

    @Override
    public void closeFile() throws JournalException {
        try {
            super.testStateChange(Transport.State.FILE_CLOSED);
            this.parent.writeDocumentTrailer(this.xmlWriter);
            this.xmlWriter.close();
            this.journalFile.close();
            super.setState(Transport.State.FILE_CLOSED);
        }
        catch (XMLStreamException e) {
            throw new JournalException(e);
        }
        catch (IOException e) {
            throw new JournalException(e);
        }
    }

    @Override
    public void shutdown() throws JournalException {
        super.testStateChange(Transport.State.SHUTDOWN);
        if (super.getState() != Transport.State.SHUTDOWN) {
            super.setState(Transport.State.SHUTDOWN);
        }
    }
}

