/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.stream.XMLEventWriter;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalOperatingMode;
import org.fcrepo.server.journal.JournalWriter;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.CreatorJournalEntry;
import org.fcrepo.server.journal.entry.JournalEntry;
import org.fcrepo.server.journal.helpers.JournalHelper;
import org.fcrepo.server.journal.helpers.ParameterHelper;
import org.fcrepo.server.journal.readerwriter.multicast.JournalEntrySizeEstimator;
import org.fcrepo.server.journal.readerwriter.multicast.Transport;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;
import org.fcrepo.server.journal.readerwriter.multicast.request.CloseFileRequest;
import org.fcrepo.server.journal.readerwriter.multicast.request.OpenFileRequest;
import org.fcrepo.server.journal.readerwriter.multicast.request.ShutdownRequest;
import org.fcrepo.server.journal.readerwriter.multicast.request.TransportRequest;
import org.fcrepo.server.journal.readerwriter.multicast.request.WriteEntryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulticastJournalWriter
extends JournalWriter
implements TransportParent {
    private static final Logger logger = LoggerFactory.getLogger(MulticastJournalWriter.class);
    public static final String TRANSPORT_PARAMETER_PREFIX = "transport.";
    public static final String CLASSNAME_PARAMETER_KEY = "classname";
    public static final String CRUCIAL_PARAMETER_KEY = "crucial";
    private static final Class<?>[] TRANSPORT_CONSTRUCTOR_ARGUMENT_TYPES = new Class[]{Map.class, Boolean.TYPE, TransportParent.class};
    private final String filenamePrefix;
    private final long sizeLimit;
    private final long ageLimit;
    private final Map<String, Map<String, String>> transportParameters;
    private final Map<String, Transport> transports;
    private Transport.State state = Transport.State.FILE_CLOSED;
    private long currentSize;
    private final JournalEntrySizeEstimator sizeEstimator;
    private Timer timer;

    public MulticastJournalWriter(Map<String, String> parameters, String role, ServerInterface server) throws JournalException {
        super(parameters, role, server);
        this.filenamePrefix = ParameterHelper.parseParametersForFilenamePrefix(parameters);
        this.sizeLimit = ParameterHelper.parseParametersForSizeLimit(parameters);
        this.ageLimit = ParameterHelper.parseParametersForAgeLimit(parameters);
        this.transportParameters = this.parseTransportParameters(parameters);
        this.checkTransportParametersForValidity();
        this.transports = this.createTransports();
        this.sizeEstimator = new JournalEntrySizeEstimator(this);
    }

    private Map<String, Map<String, String>> parseTransportParameters(Map<String, String> parameters) throws JournalException {
        LinkedHashMap<String, Map<String, String>> allTransports = new LinkedHashMap<String, Map<String, String>>();
        for (String key : parameters.keySet()) {
            if (!this.isTransportParameter(key)) continue;
            Map<String, String> thisTransport = this.getThisTransportMap(allTransports, this.getTransportName(key));
            thisTransport.put(this.getTransportParameterName(key), parameters.get(key));
        }
        return allTransports;
    }

    private boolean isTransportParameter(String key) throws JournalException {
        return key.startsWith(TRANSPORT_PARAMETER_PREFIX);
    }

    private int findParameterNameSeparator(String key) throws JournalException {
        int dotHere = key.indexOf(46, TRANSPORT_PARAMETER_PREFIX.length());
        if (dotHere < 0) {
            throw new JournalException("Invalid name for transport parameter '" + key + "' - requires '.' after transport name.");
        }
        return dotHere;
    }

    private String getTransportParameterName(String key) throws JournalException {
        return key.substring(this.findParameterNameSeparator(key) + 1);
    }

    private String getTransportName(String key) throws JournalException {
        return key.substring(TRANSPORT_PARAMETER_PREFIX.length(), this.findParameterNameSeparator(key));
    }

    private Map<String, String> getThisTransportMap(Map<String, Map<String, String>> allTransports, String transportName) {
        if (!allTransports.containsKey(transportName)) {
            allTransports.put(transportName, new HashMap());
        }
        return allTransports.get(transportName);
    }

    protected void checkTransportParametersForValidity() throws JournalException {
        this.checkAtLeastOneTransport();
        this.checkAllTransportsHaveClassnames();
        this.checkAllTransportsHaveCrucialFlags();
        this.checkAtLeastOneCrucialTransport();
        logger.info("Journal transport parameters validated.");
    }

    private void checkAtLeastOneTransport() throws JournalException {
        if (this.transportParameters.size() == 0) {
            throw new JournalException("MulticastJournalWriter must have at least one Transport.");
        }
    }

    private void checkAllTransportsHaveClassnames() throws JournalException {
        for (String transportName : this.transportParameters.keySet()) {
            Map<String, String> thisTransportMap = this.transportParameters.get(transportName);
            if (thisTransportMap.containsKey(CLASSNAME_PARAMETER_KEY)) continue;
            throw new JournalException("Transport '" + transportName + "' does not have a '" + CLASSNAME_PARAMETER_KEY + "' parameter");
        }
    }

    private void checkAllTransportsHaveCrucialFlags() throws JournalException {
        for (String transportName : this.transportParameters.keySet()) {
            Map<String, String> thisTransportMap = this.transportParameters.get(transportName);
            if (thisTransportMap.containsKey(CRUCIAL_PARAMETER_KEY)) continue;
            throw new JournalException("Transport '" + transportName + "' does not have a '" + CRUCIAL_PARAMETER_KEY + "' parameter");
        }
    }

    private void checkAtLeastOneCrucialTransport() throws JournalException {
        for (String transportName : this.transportParameters.keySet()) {
            Map<String, String> thisTransportMap = this.transportParameters.get(transportName);
            String crucialString = thisTransportMap.get(CRUCIAL_PARAMETER_KEY);
            if (!Boolean.parseBoolean(crucialString)) continue;
            return;
        }
        throw new JournalException("There must be at least one crucial transport.");
    }

    private Map<String, Transport> createTransports() throws JournalException {
        HashMap<String, Transport> result = new HashMap<String, Transport>();
        for (String transportName : this.transportParameters.keySet()) {
            Map<String, String> thisTransportMap = this.transportParameters.get(transportName);
            String className = thisTransportMap.get(CLASSNAME_PARAMETER_KEY);
            boolean crucialFlag = Boolean.parseBoolean(thisTransportMap.get(CRUCIAL_PARAMETER_KEY));
            Object transport = JournalHelper.createInstanceFromClassname((String)className, (Class[])TRANSPORT_CONSTRUCTOR_ARGUMENT_TYPES, (Object[])new Object[]{thisTransportMap, crucialFlag, this});
            logger.info("Transport '" + transportName + "' is " + transport);
            result.put(transportName, (Transport)transport);
        }
        return result;
    }

    Map<String, Transport> getTransports() {
        return this.transports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToWriteJournalEntry() throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (this.state == Transport.State.SHUTDOWN) {
                return;
            }
            logger.debug("Preparing to write journal entry.");
            if (this.state == Transport.State.FILE_OPEN) {
                this.closeFileIfAppropriate();
            }
            if (this.state == Transport.State.FILE_CLOSED) {
                this.openNewFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJournalEntry(CreatorJournalEntry journalEntry) throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (this.state == Transport.State.SHUTDOWN) {
                return;
            }
            logger.debug("Writing journal entry.");
            this.sendRequestToAllTransports(new WriteEntryRequest(this, journalEntry));
            this.currentSize += this.sizeEstimator.estimateSize((JournalEntry)journalEntry);
            if (this.state == Transport.State.FILE_OPEN) {
                this.closeFileIfAppropriate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (this.state == Transport.State.SHUTDOWN) {
                return;
            }
            if (this.state == Transport.State.FILE_OPEN) {
                this.closeFile();
            }
            logger.debug("Shutting down.");
            this.sendRequestToAllTransports(new ShutdownRequest());
            this.state = Transport.State.SHUTDOWN;
        }
    }

    private void openNewFile() throws JournalException {
        try {
            String hash = this.server.getRepositoryHash();
            String filename = JournalHelper.createTimestampedFilename((String)this.filenamePrefix, (Date)this.getCurrentDate());
            this.timer = this.createTimer();
            this.sendRequestToAllTransports(new OpenFileRequest(hash, filename, this.getCurrentDate()));
            this.currentSize = 0L;
            this.state = Transport.State.FILE_OPEN;
        }
        catch (ServerException e) {
            throw new JournalException(e);
        }
    }

    protected Date getCurrentDate() {
        return new Date();
    }

    private Timer createTimer() {
        Timer fileTimer = new Timer();
        if (this.ageLimit >= 0L) {
            fileTimer.schedule((TimerTask)new CloseFileTimerTask(), this.ageLimit);
        }
        return fileTimer;
    }

    private void closeFileIfAppropriate() throws JournalException {
        if (this.sizeLimit != 0L && this.currentSize >= this.sizeLimit) {
            this.closeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeFile() throws JournalException {
        Object object = JournalWriter.SYNCHRONIZER;
        synchronized (object) {
            if (this.state == Transport.State.FILE_OPEN) {
                this.sendRequestToAllTransports(new CloseFileRequest());
                this.currentSize = 0L;
                this.state = Transport.State.FILE_CLOSED;
            }
            if (this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    public void writeJournalEntry(CreatorJournalEntry journalEntry, XMLEventWriter writer) throws JournalException {
        super.writeJournalEntry(journalEntry, writer);
    }

    @Override
    public void writeDocumentHeader(XMLEventWriter writer, String repositoryHash, Date currentDate) throws JournalException {
        super.writeDocumentHeader(writer, repositoryHash, currentDate);
    }

    @Override
    public void writeDocumentTrailer(XMLEventWriter writer) throws JournalException {
        super.writeDocumentTrailer(writer);
    }

    private void sendRequestToAllTransports(TransportRequest request) throws JournalException {
        LinkedHashMap<String, JournalException> crucialExceptions = new LinkedHashMap<String, JournalException>();
        LinkedHashMap<String, JournalException> nonCrucialExceptions = new LinkedHashMap<String, JournalException>();
        for (String transportName : this.transports.keySet()) {
            Transport transport = this.transports.get(transportName);
            try {
                logger.debug("Sending " + request.getClass().getSimpleName() + " to transport '" + transportName + "'");
                request.performRequest(transport);
            }
            catch (JournalException e) {
                if (transport.isCrucial()) {
                    crucialExceptions.put(transportName, e);
                    continue;
                }
                nonCrucialExceptions.put(transportName, e);
            }
        }
        this.reportNonCrucialExceptions(nonCrucialExceptions);
        this.reportCrucialExceptions(crucialExceptions);
    }

    private void reportNonCrucialExceptions(Map<String, JournalException> nonCrucialExceptions) {
        if (nonCrucialExceptions.isEmpty()) {
            return;
        }
        for (String transportName : nonCrucialExceptions.keySet()) {
            JournalException e = nonCrucialExceptions.get(transportName);
            logger.error("Exception thrown from non-crucial Journal Transport: '" + transportName + "'", (Throwable)e);
        }
    }

    private void reportCrucialExceptions(Map<String, JournalException> crucialExceptions) throws JournalException {
        if (!crucialExceptions.isEmpty()) {
            JournalOperatingMode.setMode((JournalOperatingMode)JournalOperatingMode.READ_ONLY);
        }
        for (String transportName : crucialExceptions.keySet()) {
            JournalException e = crucialExceptions.get(transportName);
            logger.error("Exception thrown from crucial Journal Transport: '" + transportName + "'", (Throwable)e);
        }
    }

    private final class CloseFileTimerTask
    extends TimerTask {
        private CloseFileTimerTask() {
        }

        @Override
        public void run() {
            try {
                logger.debug("Timer task requests file close.");
                MulticastJournalWriter.this.closeFile();
            }
            catch (JournalException e) {
                e.printStackTrace();
                throw new IllegalStateException(e);
            }
        }
    }
}

