/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.rmi.AlreadyBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.TransportOutputFile;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverArguments;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverHelper;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmiJournalReceiver
extends UnicastRemoteObject
implements RmiJournalReceiverInterface {
    private static final Logger logger = LoggerFactory.getLogger(RmiJournalReceiver.class);
    private final RmiJournalReceiverArguments arguments;
    private final File directory;
    private TransportOutputFile journalFile;
    private long itemIndex;
    private Writer writer;
    private String currentRepositoryHash;

    public RmiJournalReceiver(RmiJournalReceiverArguments arguments) throws RemoteException {
        super(arguments.getServerPortNumber());
        this.arguments = arguments;
        this.directory = arguments.getDirectoryPath();
    }

    public void exportAndBind() throws RemoteException, AlreadyBoundException, InterruptedException {
        Registry registry = LocateRegistry.createRegistry(this.arguments.getRegistryPortNumber());
        registry.rebind("RmiJournalReceiver", this);
        Thread.sleep(2000L);
        logger.info("RmiJournalReceiver is ready - journal directory is '" + this.arguments.getDirectoryPath().getAbsolutePath() + "'");
    }

    @Override
    public void openFile(String repositoryHash, String filename) throws JournalException {
        if (this.journalFile != null) {
            throw this.logAndGetException("Attempting to open file '" + filename + "' when file '" + this.journalFile.getName() + "' has not been closed.");
        }
        try {
            this.journalFile = new TransportOutputFile(this.directory, filename);
            this.writer = this.journalFile.open();
        }
        catch (IOException e) {
            throw this.logAndGetException("Problem opening" + filename + "'", e);
        }
        this.currentRepositoryHash = repositoryHash;
        this.itemIndex = 0L;
        logger.debug("opened file '" + filename + "', hash is '" + repositoryHash + "'");
    }

    @Override
    public void writeText(String indexedHash, String text) throws JournalException {
        if (this.journalFile == null) {
            throw this.logAndGetException("Attempting to write when no file is open.");
        }
        String calculatedHash = RmiJournalReceiverHelper.figureIndexedHash(this.currentRepositoryHash, this.itemIndex);
        if (!calculatedHash.equals(indexedHash)) {
            logger.debug("calculatedHash='" + calculatedHash + "', providedHash='" + indexedHash + "'");
            throw this.logAndGetException("indexed hash is incorrect.");
        }
        try {
            this.writer.append(text);
            this.writer.flush();
        }
        catch (IOException e) {
            throw this.logAndGetException("Failed to write to '" + this.journalFile.getName() + "'", e);
        }
        logger.debug("Wrote item #" + this.itemIndex + " to file '" + this.journalFile.getName() + "'");
        ++this.itemIndex;
    }

    @Override
    public void closeFile() throws JournalException {
        if (this.journalFile == null) {
            throw this.logAndGetException("Attempting to close a file when no file is open.");
        }
        try {
            this.writer.close();
            this.journalFile.close();
        }
        catch (IOException e) {
            throw this.logAndGetException("Problem closing the file '" + this.journalFile.getName() + "'", e);
        }
        logger.debug("closing file: '" + this.journalFile.getName() + "'");
        this.journalFile = null;
    }

    private JournalException logAndGetException(String message) {
        logger.error(message);
        return new JournalException(message);
    }

    private JournalException logAndGetException(String message, Throwable e) {
        logger.error(message, e);
        return new JournalException(message + ": " + e.toString());
    }

    public static void main(String[] args) {
        try {
            RmiJournalReceiverArguments arguments = new RmiJournalReceiverArguments(args);
            RmiJournalReceiver receiver = new RmiJournalReceiver(arguments);
            receiver.exportAndBind();
            while (true) {
                Thread.sleep(60000L);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("RmiJournalReciever failed: " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("RmiJournalReciever failed: ");
            e.printStackTrace();
        }
    }
}

