/* The contents of this file are subject to the license and copyright terms
 * detailed in the license directory at the root of the source tree (also
 * available online at http://fedora-commons.org/license/).
 */
package org.fcrepo.server.messaging;

/**
 * Implementations should override toString() to provide a serialization of the
 * message.
 *
 * @author Edwin Shin
 * @since 3.0
 * @version $Id$
 */
public interface FedoraMessage {
    /**
     * Version of the Fedora server that produced the message
     * (version.major + version.minor), e.g. 3.0b2. Messages generated by
     * clients should return the version of the Fedora server the message
     * is intended for.
     *
     * @return Fedora server version
     */
    public String getServerVersion();

    /**
     * An identifier for the serialization format of the message.
     * @return
     */
    public String getFormat();
}
