/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.mock.sql;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.fcrepo.mock.sql.MockPreparedStatement;
import org.fcrepo.mock.sql.MockStatement;

public class MockConnection
implements Connection {
    protected boolean closed;
    protected boolean autoCommit;
    protected boolean readOnly = false;
    protected SQLWarning warnings;
    protected final List<MockStatement> statements = new ArrayList<MockStatement>();
    protected final List<MockPreparedStatement> preparedStatements = new ArrayList<MockPreparedStatement>();

    public void reset() {
        this.closed = false;
        this.autoCommit = false;
        this.warnings = null;
        this.statements.clear();
        this.preparedStatements.clear();
    }

    public List<MockStatement> getStatements() {
        return new ArrayList<MockStatement>(this.statements);
    }

    public List<MockPreparedStatement> getPreparedStatements() {
        return new ArrayList<MockPreparedStatement>(this.preparedStatements);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warnings = null;
    }

    @Override
    public void close() throws SQLException {
        for (MockPreparedStatement stmt : this.preparedStatements) {
            stmt.close();
        }
        this.closed = true;
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warnings;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        MockPreparedStatement stmt = new MockPreparedStatement(sql);
        this.preparedStatements.add(stmt);
        return stmt;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
    }

    @Override
    public Statement createStatement() throws SQLException {
        MockStatement stmt = new MockStatement();
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        this.readOnly = arg0;
    }

    @Override
    public void commit() throws SQLException {
        throw new RuntimeException("MockConnection.commit not implemented");
    }

    @Override
    public Statement createStatement(int arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockConnection.createStatement not implemented");
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockConnection.createStatement not implemented");
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new RuntimeException("MockConnection.getCatalog not implemented");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new RuntimeException("MockConnection.getHoldability not implemented");
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new RuntimeException("MockConnection.getMetaData not implemented");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new RuntimeException("MockConnection.getTransactionIsolation not implemented");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new RuntimeException("MockConnection.getTypeMap not implemented");
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new RuntimeException("MockConnection.nativeSQL not implemented");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new RuntimeException("MockConnection.prepareCall not implemented");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockConnection.prepareCall not implemented");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new RuntimeException("MockConnection.prepareCall not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1) throws SQLException {
        throw new RuntimeException("MockConnection.prepareStatement not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int[] arg1) throws SQLException {
        throw new RuntimeException("MockConnection.prepareStatement not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, String[] arg1) throws SQLException {
        throw new RuntimeException("MockConnection.prepareStatement not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2) throws SQLException {
        throw new RuntimeException("MockConnection.prepareStatement not implemented");
    }

    @Override
    public PreparedStatement prepareStatement(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new RuntimeException("MockConnection.prepareStatement not implemented");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new RuntimeException("MockConnection.releaseSavepoint not implemented");
    }

    @Override
    public void rollback() throws SQLException {
        throw new RuntimeException("MockConnection.rollback not implemented");
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
        throw new RuntimeException("MockConnection.rollback not implemented");
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new RuntimeException("MockConnection.setCatalog not implemented");
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new RuntimeException("MockConnection.setHoldability not implemented");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new RuntimeException("MockConnection.setSavepoint not implemented");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new RuntimeException("MockConnection.setSavepoint not implemented");
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new RuntimeException("MockConnection.setTransactionIsolation not implemented");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new RuntimeException("MockConnection.setTypeMap not implemented");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException("Java 1.6 JDBC methods are not supported");
    }
}

