/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.server.journal.AbstractJournalTester;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.readerwriter.multicast.LocalDirectoryTransport;
import org.fcrepo.server.journal.readerwriter.multicast.MockMulticastJournalWriter;
import org.fcrepo.server.journal.readerwriter.multicast.TestMulticastJournalWriterInitializations;
import org.fcrepo.server.journal.readerwriter.multicast.TransportParent;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLocalDirectoryTransport
extends AbstractJournalTester {
    private static final String EXPECTED_JOURNAL_1_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<FedoraJournal repositoryHash=\"firstSillyHash\" timestamp=\"2007-03-05T16:49:21.392-0500\">\n  <junkElement1a></junkElement1a>\n  <junkElement1b></junkElement1b></FedoraJournal>\n";
    private static final String EXPECTED_JOURNAL_2_CONTENTS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<FedoraJournal repositoryHash=\"secondSillyHash\" timestamp=\"2007-03-05T16:49:21.392-0500\">\n  <junkElement2></junkElement2></FedoraJournal>\n";
    private static File journalDirectory;
    private static final boolean CRUCIAL = true;
    private Map<String, String> parameters;
    private MockMulticastJournalWriter parent;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestMulticastJournalWriterInitializations.class);
    }

    @BeforeClass
    public static void initalizeJournalDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        journalDirectory = new File(tempDirectory, "TestLocalDirectoryTransport");
        journalDirectory.mkdirs();
    }

    @Before
    public void cleanJournalDirectory() {
        this.deleteDirectoryContents(journalDirectory);
    }

    @Before
    public void initalizeBasicParameters() {
        this.parameters = new HashMap<String, String>();
        this.parameters.put("directoryPath", journalDirectory.getAbsolutePath());
    }

    @Before
    public void initializeTransportParent() throws JournalException {
        MockServerForJournalTesting server = new MockServerForJournalTesting(new MockManagementDelegate(), "myHashValue");
        this.parent = new MockMulticastJournalWriter(new HashMap<String, String>(), null, server);
    }

    @Test
    public void testParameterNoDirectoryPath() {
        this.parameters.remove("directoryPath");
        try {
            new LocalDirectoryTransport(this.parameters, true, null);
            Assert.fail((String)"expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testParametersInvalidDirectory() {
        this.parameters.put("directoryPath", "BogusDirectoryName");
        try {
            new LocalDirectoryTransport(this.parameters, true, null);
            Assert.fail((String)"expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testParametersSuccess() throws JournalException {
        new LocalDirectoryTransport(this.parameters, true, null);
    }

    @Test
    public void testOperations() throws JournalException, IOException, XMLStreamException, ParseException {
        XMLEventFactory factory = XMLEventFactory.newInstance();
        QName name1a = new QName("junkElement1a");
        QName name1b = new QName("junkElement1b");
        QName name2 = new QName("junkElement2");
        SimpleDateFormat parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        this.parent.setCurrentDate(parser.parse("2007-03-05T16:49:21.392-0500"));
        transport.openFile("firstSillyHash", "fileOne", this.parent.getCurrentDate());
        File tempfile1 = new File(journalDirectory, "_fileOne");
        this.assertFileExists(tempfile1);
        transport.getWriter().add(factory.createStartElement(name1a, null, null));
        transport.getWriter().add(factory.createEndElement(name1a, null));
        transport.getWriter().add(factory.createStartElement(name1b, null, null));
        transport.getWriter().add(factory.createEndElement(name1b, null));
        transport.closeFile();
        File file1 = new File(journalDirectory, "fileOne");
        this.assertFileExists(file1);
        this.assertFileDoesNotExist(tempfile1);
        transport.openFile("secondSillyHash", "fileTwo", this.parent.getCurrentDate());
        File tempfile2 = new File(journalDirectory, "_fileTwo");
        this.assertFileExists(tempfile2);
        transport.getWriter().add(factory.createStartElement(name2, null, null));
        transport.getWriter().add(factory.createEndElement(name2, null));
        transport.closeFile();
        File file2 = new File(journalDirectory, "fileTwo");
        this.assertFileExists(file2);
        this.assertFileDoesNotExist(tempfile2);
        transport.shutdown();
        this.assertFileContents(EXPECTED_JOURNAL_1_CONTENTS, file1);
        this.assertFileContents(EXPECTED_JOURNAL_2_CONTENTS, file2);
    }

    @Test
    public void testUnableToCreateFile() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, null);
        try {
            transport.openFile("firstSillyHash", ":", new Date());
            Assert.fail((String)"expecting JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testFileAlreadyExists() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("firstSillyHash", "fileOne", new Date());
        transport.closeFile();
        try {
            transport.openFile("secondSillyHash", "fileOne", new Date());
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testOpenAfterShutdown() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.shutdown();
        try {
            transport.openFile("firstSillyHash", "fileOne", new Date());
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWriterAfterShutdown() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("firstSillyHash", "fileOne", new Date());
        transport.closeFile();
        transport.shutdown();
        try {
            transport.getWriter();
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseAfterShutdown() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.shutdown();
        try {
            transport.closeFile();
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownAfterShutdown() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.shutdown();
        transport.shutdown();
    }

    @Test
    public void testOpenAfterOpen() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("firstSillyHash", "Open", new Date());
        try {
            transport.openFile("firstSillyHash", "OpenOpen", new Date());
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testShutdownAfterOpen() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("firstSillyHash", "OpenBeforeShutdown", new Date());
        try {
            transport.shutdown();
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException e) {
            transport.closeFile();
        }
    }

    @Test
    public void testCloseAfterClose() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("firstSillyHash", "CloseClose", new Date());
        transport.closeFile();
        try {
            transport.closeFile();
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @Test
    public void testGetWriterAfterClose() throws JournalException {
        LocalDirectoryTransport transport = new LocalDirectoryTransport(this.parameters, true, (TransportParent)this.parent);
        transport.openFile("whoCaresHash", "CloseGetWriter", new Date());
        transport.closeFile();
        try {
            transport.getWriter();
            Assert.fail((String)"Expected a JournalException");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }
}

