/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.File;
import java.rmi.RemoteException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.journal.AbstractJournalTester;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiver;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverArguments;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverHelper;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.TestRmiTransport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class TestRmiJournalReceiver
extends AbstractJournalTester {
    private static File journalDirectory;
    private static int fileIndex;

    public static Test suite() {
        return new JUnit4TestAdapter(TestRmiTransport.class);
    }

    @BeforeClass
    public static void initializeJournalDirectory() {
        File tempDirectory = new File(System.getProperty("java.io.tmpdir"));
        journalDirectory = new File(tempDirectory, "TestRmiJournalReceiver");
        journalDirectory.mkdirs();
    }

    @BeforeClass
    public static void initializeFileIndex() {
        fileIndex = 0;
    }

    @Before
    public void cleanJournalDirectory() {
        this.deleteDirectoryContents(journalDirectory);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testNoDirectoryPath() throws RemoteException {
        this.createReceiver(new String[0]);
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testDirectoryDoesNotExist() throws RemoteException {
        this.createReceiver(new String[]{"BogusDirectory"});
    }

    @org.junit.Test
    public void testValidOneArg() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath()});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testInvalidRegistryPortNumber() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "BogusPort"});
    }

    @org.junit.Test
    public void testValidTwoArgs() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234"});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testInvalidServerPortNumber() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "BogusServerPort"});
    }

    @org.junit.Test
    public void testValidThreeArgs() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235"});
    }

    @org.junit.Test(expected=IllegalArgumentException.class)
    public void testInvalidLogLevel() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "BogusLogLevel"});
    }

    @org.junit.Test
    public void testValidFourArgs() throws RemoteException {
        this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "INFO"});
    }

    @org.junit.Test
    public void testNormalSequence() throws RemoteException, JournalException {
        String text1 = "Write this text!";
        String text2 = "  And some more also.";
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath()});
        String filename = this.getFilename();
        receiver.openFile("SomeSillyHash", filename);
        receiver.writeText(RmiJournalReceiverHelper.figureIndexedHash((String)"SomeSillyHash", (long)0L), text1);
        receiver.writeText(RmiJournalReceiverHelper.figureIndexedHash((String)"SomeSillyHash", (long)1L), text2);
        receiver.closeFile();
        this.assertFileContents(text1 + text2, new File(journalDirectory, filename));
    }

    @org.junit.Test
    public void testIncorrectItemHash() throws RemoteException, JournalException {
        String text1 = "This won't work.";
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        String filename = this.getFilename();
        receiver.openFile("RepoHash", filename);
        try {
            receiver.writeText("BogusItemHash", text1);
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException e) {
            receiver.closeFile();
        }
    }

    @org.junit.Test
    public void testOpenAfterOpen() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        receiver.openFile("RepoHash", this.getFilename());
        try {
            receiver.openFile("RepoHash", this.getFilename());
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException e) {
            receiver.closeFile();
        }
    }

    @org.junit.Test
    public void testCloseWithoutOpen() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        try {
            receiver.closeFile();
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCloseAfterClose() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        receiver.openFile("RepoHash", this.getFilename());
        receiver.closeFile();
        try {
            receiver.closeFile();
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testWriteAfterClose() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        receiver.openFile("RepoHash", this.getFilename());
        receiver.closeFile();
        try {
            receiver.writeText(this.getIndexHash("RepoHash", 0), "Some bogus text");
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testFileExists() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        String filename = this.getFilename();
        receiver.openFile("RepoHash", filename);
        receiver.closeFile();
        try {
            receiver.openFile("RepoHash", filename);
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    @org.junit.Test
    public void testCantCreateFile() throws RemoteException, JournalException {
        RmiJournalReceiver receiver = this.createReceiver(new String[]{journalDirectory.getAbsolutePath(), "1234", "1235", "FATAL"});
        try {
            receiver.openFile("RepoHash", ":");
            Assert.fail((String)"Expected an exception.");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    private RmiJournalReceiver createReceiver(String[] args) throws RemoteException {
        return new RmiJournalReceiver(new RmiJournalReceiverArguments(args));
    }

    private String getFilename() {
        return "journal" + fileIndex++;
    }

    private String getIndexHash(String repoHash, int itemIndex) {
        return RmiJournalReceiverHelper.figureIndexedHash((String)repoHash, (long)itemIndex);
    }
}

