/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal.readerwriter.multicast.rmi;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Date;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.MockRmiJournalReceiver;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverHelper;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiJournalReceiverInterface;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.RmiTransportWriter;
import org.fcrepo.server.journal.readerwriter.multicast.rmi.TestRmiTransport;
import org.junit.Before;

public class TestRmiTransportWriter {
    MockRmiJournalReceiver receiver;
    String repositoryHash;

    public static Test suite() {
        return new JUnit4TestAdapter(TestRmiTransport.class);
    }

    @Before
    public void initializeReceiver() throws RemoteException {
        this.receiver = new MockRmiJournalReceiver();
    }

    @Before
    public void initializeRepositoryHash() {
        this.repositoryHash = "Hash" + new Date().getTime();
    }

    @org.junit.Test
    public void testConstructorOpensConnection() throws JournalException {
        new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        Assert.assertEquals((String)this.repositoryHash, (String)this.receiver.getRepositoryHash());
        Assert.assertEquals((String)"theFilename", (String)this.receiver.getFilename());
    }

    @org.junit.Test(expected=JournalException.class)
    public void testConstructorGetsException() throws JournalException {
        this.receiver.setOpenFileThrowsException(true);
        new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
    }

    @org.junit.Test
    public void testSeriesOfWrites() throws JournalException, IOException {
        RmiTransportWriter writer = new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        String text1 = "Some silly text";
        char[] chars = text1.toCharArray();
        writer.write(chars, 0, text1.length());
        this.assertCorrectNumberOfCalls(this.receiver, 1, 1, 0);
        Assert.assertEquals((String)"unexpected text 1", (String)text1, (String)this.receiver.getText());
        this.assertCorrectItemHash(this.receiver, 0);
        String text2 = "This is something else";
        writer.write(text2);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 2, 0);
        Assert.assertEquals((String)"unexpected text 2", (String)text2, (String)this.receiver.getText());
        this.assertCorrectItemHash(this.receiver, 1);
        String text3 = "What's going on?";
        writer.write(text3, 3, 8);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 3, 0);
        Assert.assertEquals((String)"unexpected text 3", (String)text3.substring(3, 11), (String)this.receiver.getText());
        this.assertCorrectItemHash(this.receiver, 2);
    }

    @org.junit.Test(expected=IOException.class)
    public void testWriteGetsException() throws JournalException, IOException {
        this.receiver.setWriteTextThrowsException(true);
        RmiTransportWriter writer = new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
        writer.write("Throw an exception");
    }

    @org.junit.Test
    public void testCloseClosesFile() throws JournalException, IOException {
        RmiTransportWriter writer = new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
        writer.close();
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 1);
    }

    @org.junit.Test(expected=IOException.class)
    public void testCloseThrowsException() throws JournalException, IOException {
        this.receiver.setCloseFileThrowsException(true);
        RmiTransportWriter writer = new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename");
        writer.close();
    }

    @org.junit.Test
    public void testBigBufferYieldsOnlyOneWrite() throws JournalException, IOException {
        String text1 = "Write a bunch of stuff to the buffer";
        String text2 = "But it doesn't go out to the RmiTransportWriter";
        String text3 = "Until we do a flush or a close.";
        BufferedWriter buffered = new BufferedWriter((Writer)new RmiTransportWriter((RmiJournalReceiverInterface)this.receiver, this.repositoryHash, "theFilename"), 10000);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        buffered.write(text1);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        buffered.write(text2);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        buffered.write(text3);
        this.assertCorrectNumberOfCalls(this.receiver, 1, 0, 0);
        buffered.flush();
        this.assertCorrectNumberOfCalls(this.receiver, 1, 1, 0);
        Assert.assertEquals((String)"unexpected text", (String)(text1 + text2 + text3), (String)this.receiver.getText());
    }

    private void assertCorrectItemHash(MockRmiJournalReceiver receiver, int index) {
        Assert.assertEquals((String)"unexpected item hash", (String)RmiJournalReceiverHelper.figureIndexedHash((String)this.repositoryHash, (long)index), (String)receiver.getIndexedHash());
    }

    private void assertCorrectNumberOfCalls(MockRmiJournalReceiver receiver, int i, int j, int k) {
        Assert.assertEquals((String)"wrong number of calls to openFile()", (int)i, (int)receiver.howManyCallsToOpenFile());
        Assert.assertEquals((String)"wrong number of calls to writeText()", (int)j, (int)receiver.howManyCallsToWriteText());
        Assert.assertEquals((String)"wrong number of calls to closeFile()", (int)k, (int)receiver.howManyCallsToClosefile());
    }
}

