/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.Collections;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.resourceIndex.ResourceIndexIntegrationTest;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.Triple;
import org.junit.Assert;

public class ResourceIndexAddDelMiscIntegrationTest
extends ResourceIndexIntegrationTest {
    @org.junit.Test
    public void testAddDelObjLv0() throws Exception {
        Set<DigitalObject> objects = ResourceIndexAddDelMiscIntegrationTest.getTestObjects(1, 0);
        this.initRI(0);
        this.addAll(objects, true);
        Assert.assertEquals((String)"Did not get expected triples after add", (Object)Collections.EMPTY_SET, this.getActualTriples());
        this.initRI(1);
        this.addAll(objects, true);
        Set<Triple> expected = this.getExpectedTriples(1, objects);
        this.initRI(0);
        this.deleteAll(objects, true);
        Assert.assertTrue((String)"Did not get expected triples after delete", (boolean)this.sameTriples(expected, this.getActualTriples(), true));
    }

    @org.junit.Test
    public void testAddDelMultiObjOneDS() throws Exception {
        Set<DigitalObject> objects = ResourceIndexAddDelMiscIntegrationTest.getTestObjects(5, 1);
        this.doAddDelTest(1, objects);
    }

    @org.junit.Test
    public void testAddDelMultiObjMultiDS() throws Exception {
        Set<DigitalObject> objects = ResourceIndexAddDelMiscIntegrationTest.getTestObjects(5, 5);
        this.doAddDelTest(1, objects);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ResourceIndexAddDelMiscIntegrationTest.class);
    }
}

