/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.security;

import java.io.IOException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ValidationException;
import org.fcrepo.server.security.MockPolicyParser;
import org.fcrepo.server.security.PolicyParser;
import org.fcrepo.server.utilities.StreamUtility;
import org.xml.sax.SAXException;

public class TestPolicyParser {
    public static final String POLICY_GOODENOUGH = "<Policy PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>";
    public static final String POLICY_QUESTIONABLE = "<Policy unexpectedAttribute='thisOne' PolicyId='foo' RuleCombiningAlgId='urn:oasis:names:tc:xacml:1.0:rule-combining-algorithm:first-applicable'/>";
    public static final String SCHEMA_GOODENOUGH = "<schema xmlns='" + Constants.XML_XSD.uri + "'><element name='P" + "olicy'><complexType><sequence><any minOccurs='0' maxOccurs='unb" + "ounded' processContents='skip'/></sequence><attribute name='Pol" + "icyId'/><attribute name='RuleCombiningAlgId'/></complexType></e" + "lement></schema>";
    private static final String POLICY_BADROOT = "<not-a-policy/>";
    private static final String POLICY_GOODROOT_NOCONTENT = "<Policy/>";
    private static final String POLICY_MALFORMEDXML = "notxml";
    private static final String SCHEMA_BAD = "<not-a-schema/>";

    @org.junit.Test(expected=SAXException.class)
    public void testConstructWithBadSchema() throws IOException, SAXException {
        new PolicyParser(StreamUtility.getStream((String)SCHEMA_BAD));
    }

    @org.junit.Test
    public void testConstructWithValidSchema() throws IOException, SAXException {
        new MockPolicyParser();
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseMalformedXMLValidationFalse() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_MALFORMEDXML), false);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseMalformedXMLValidationTrue() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_MALFORMEDXML), true);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseBadRootValidationFalse() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_BADROOT), false);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseBadRootValidationTrue() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_BADROOT), true);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseGoodRootNoContentValidationFalse() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_GOODROOT_NOCONTENT), false);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseGoodRootNoContentValidationTrue() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_GOODROOT_NOCONTENT), true);
    }

    @org.junit.Test
    public void testParseGoodRootQuestionableContentValidationFalse() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_QUESTIONABLE), false);
    }

    @org.junit.Test(expected=ValidationException.class)
    public void testParseGoodRootQuestionableContentValidationTrue() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_QUESTIONABLE), true);
    }

    @org.junit.Test
    public void testParseGoodRootGoodContentValidationFalse() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_GOODENOUGH), false);
    }

    @org.junit.Test
    public void testParseGoodRootGoodContentValidationTrue() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.parse(StreamUtility.getStream((String)POLICY_GOODENOUGH), true);
    }

    @org.junit.Test
    public void testParseGoodRootGoodContentValidationTrueWithCopy() throws IOException, SAXException, ValidationException {
        MockPolicyParser parser = new MockPolicyParser();
        parser.copy().parse(StreamUtility.getStream((String)POLICY_GOODENOUGH), true);
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestPolicyParser.class);
    }
}

