/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.fcrepo.common.Constants;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.storage.DOReader;
import org.fcrepo.server.storage.types.AuditRecord;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectMethodsDef;
import org.fcrepo.server.storage.types.RelationshipTuple;
import org.jrdf.graph.ObjectNode;
import org.jrdf.graph.PredicateNode;
import org.jrdf.graph.SubjectNode;

public class MockDOReader
implements DOReader {
    protected final DigitalObject theObject;

    public MockDOReader(DigitalObject theObject) {
        this.theObject = theObject;
    }

    public DigitalObject getObject() {
        return this.theObject;
    }

    public Datastream GetDatastream(String datastreamID, Date versDateTime) throws ServerException {
        ArrayList<Datastream> datastreams = new ArrayList<Datastream>();
        for (Datastream d : this.theObject.datastreams(datastreamID)) {
            datastreams.add(d);
        }
        if (datastreams.isEmpty()) {
            return null;
        }
        Collections.sort(datastreams, new Comparator<Datastream>(){

            @Override
            public int compare(Datastream o1, Datastream o2) {
                return o2.DSCreateDT.compareTo(o1.DSCreateDT);
            }
        });
        if (versDateTime == null) {
            return (Datastream)datastreams.get(0);
        }
        for (Datastream datastream : datastreams) {
            if (!datastream.DSCreateDT.before(versDateTime)) continue;
            return datastream;
        }
        return null;
    }

    public String GetObjectLabel() throws ServerException {
        return this.theObject.getLabel();
    }

    public String GetObjectPID() throws ServerException {
        return this.theObject.getPid();
    }

    public String GetObjectState() throws ServerException {
        return this.theObject.getState();
    }

    public List<String> getContentModels() throws ServerException {
        ArrayList<String> list = new ArrayList<String>();
        for (RelationshipTuple rel : this.getRelationships((PredicateNode)Constants.MODEL.HAS_MODEL, null)) {
            list.add(rel.object);
        }
        return list;
    }

    public boolean hasContentModel(ObjectNode contentModel) throws ServerException {
        return this.hasRelationship((PredicateNode)Constants.MODEL.HAS_MODEL, contentModel);
    }

    public Date getCreateDate() throws ServerException {
        return this.theObject.getCreateDate();
    }

    public Date getLastModDate() throws ServerException {
        return this.theObject.getLastModDate();
    }

    public String getOwnerId() throws ServerException {
        return this.theObject.getOwnerId();
    }

    public boolean hasRelationship(SubjectNode s, PredicateNode p, ObjectNode o) {
        return this.theObject.hasRelationship(s, p, o);
    }

    public boolean hasRelationship(PredicateNode p, ObjectNode o) {
        return this.theObject.hasRelationship(p, o);
    }

    public Set<RelationshipTuple> getRelationships(SubjectNode s, PredicateNode p, ObjectNode o) {
        return this.theObject.getRelationships(s, p, o);
    }

    public Set<RelationshipTuple> getRelationships(PredicateNode p, ObjectNode o) {
        return this.theObject.getRelationships(p, o);
    }

    public Set<RelationshipTuple> getRelationships() {
        return this.theObject.getRelationships();
    }

    public InputStream ExportObject(String format, String exportContext) throws ServerException {
        throw new RuntimeException("MockDOReader.ExportObject not implemented");
    }

    public InputStream Export(String format, String exportContext) throws ServerException {
        throw new RuntimeException("MockDOReader.Export not implemented");
    }

    public Datastream[] GetDatastreams(Date versDateTime, String state) throws ServerException {
        throw new RuntimeException("MockDOReader.GetDatastreams not implemented");
    }

    public InputStream GetObjectXML() throws ServerException {
        throw new RuntimeException("MockDOReader.GetObjectXML not implemented");
    }

    public String[] ListDatastreamIDs(String state) throws ServerException {
        throw new RuntimeException("MockDOReader.ListDatastreamIDs not implemented");
    }

    public List<AuditRecord> getAuditRecords() throws ServerException {
        throw new RuntimeException("MockDOReader.getAuditRecords not implemented");
    }

    public Datastream getDatastream(String datastreamID, String versionID) throws ServerException {
        throw new RuntimeException("MockDOReader.getDatastream not implemented");
    }

    public Date[] getDatastreamVersions(String datastreamID) throws ServerException {
        throw new RuntimeException("MockDOReader.getDatastreamVersions not implemented");
    }

    public String[] getObjectHistory(String PID2) throws ServerException {
        throw new RuntimeException("MockDOReader.getObjectHistory not implemented");
    }

    public RelationshipTuple[] getRelationships(String relationship) throws ServerException {
        throw new RuntimeException("MockDOReader.getRelationships not implemented");
    }

    public boolean isFedoraObjectType(int type) throws ServerException {
        throw new RuntimeException("MockDOReader.isFedoraObjectType not implemented");
    }

    public ObjectMethodsDef[] listMethods(Date versDateTime) throws ServerException {
        throw new RuntimeException("MockDOReader.listMethods not implemented");
    }
}

