/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.JUnit4TestAdapter;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.common.xml.format.XMLFormat;
import org.fcrepo.server.storage.translation.AtomDOSerializer;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.FOXML1_1DODeserializer;
import org.fcrepo.server.storage.translation.TestXMLDOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.utilities.FileUtils;
import org.fcrepo.utilities.XmlTransformUtility;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestAtomDOSerializer
extends TestXMLDOSerializer {
    private static final String iso_tron = "src/main/resources/schematron/iso_schematron_skeleton.xsl";
    private static final String atom_tron = "src/main/resources/schematron/atom.sch";

    public TestAtomDOSerializer() {
        super((DOSerializer)new AtomDOSerializer());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put("fedora", "http://www.example.org");
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() throws Exception {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Test
    public void testSerializeFromFOXML() throws Exception {
        String source = "src/main/resources/demo/demo-objects/foxml/local-server-demos/image-collection-demo/dataObjects/demo_SmileyBeerGlass.xml";
        source = "src/main/resources/demo/demo-objects/foxml/local-server-demos/formatting-objects-demo/obj_demo_26.xml";
        FileInputStream in = new FileInputStream(source);
        File f = File.createTempFile("test", null);
        FileOutputStream out = new FileOutputStream(f);
        FOXML1_1DODeserializer deser = new FOXML1_1DODeserializer();
        BasicDigitalObject obj = new BasicDigitalObject();
        deser.deserialize((InputStream)in, (DigitalObject)obj, "UTF-8", 0);
        this.setObjectDefaults((DigitalObject)obj);
        AtomDOSerializer serializer = new AtomDOSerializer();
        serializer.serialize((DigitalObject)obj, (OutputStream)out, "UTF-8", 4);
    }

    @Test
    public void testSerialize() throws Exception {
        DigitalObject obj = TestAtomDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        obj.setLastModDate(new Date());
        DatastreamXMLMetadata ds1 = TestAtomDOSerializer.createXDatastream("DS1");
        ds1.DSCreateDT = new Date();
        obj.addDatastreamVersion((Datastream)ds1, true);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        AtomDOSerializer serializer = new AtomDOSerializer();
        serializer.serialize(obj, (OutputStream)out, "UTF-8", 4);
    }

    @Test
    public void testAtomZip() throws Exception {
        ZipEntry entry;
        DigitalObject obj = TestAtomDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        obj.setLastModDate(new Date());
        DatastreamXMLMetadata ds1 = TestAtomDOSerializer.createXDatastream("DS1");
        ds1.DSCreateDT = new Date();
        obj.addDatastreamVersion((Datastream)ds1, true);
        File f = File.createTempFile("atom", ".zip");
        FileOutputStream out = new FileOutputStream(f);
        AtomDOSerializer serializer = new AtomDOSerializer((XMLFormat)Constants.ATOM_ZIP1_1);
        serializer.serialize(obj, (OutputStream)out, "UTF-8", 4);
        ((OutputStream)out).close();
        ZipInputStream zip = new ZipInputStream(new FileInputStream(f));
        int count = 0;
        while ((entry = zip.getNextEntry()) != null) {
            if (!entry.getName().equals("atommanifest.xml")) continue;
            ++count;
            ByteArrayOutputStream manifest = new ByteArrayOutputStream();
            FileUtils.copy((InputStream)zip, (OutputStream)manifest);
            Abdera abdera = Abdera.getInstance();
            Parser parser = abdera.getParser();
            Document feedDoc = parser.parse((Reader)new StringReader(manifest.toString("UTF-8")));
            Feed feed = (Feed)feedDoc.getRoot();
            TestAtomDOSerializer.assertEquals((String)PID.getInstance((String)"test:pid").toURI(), (String)feed.getId().toString());
        }
        TestAtomDOSerializer.assertEquals((String)"Expected exactly 1 manifest file", (int)1, (int)count);
        zip.close();
    }

    private void validateWithISOSchematron(String candidate) throws TransformerException, IOException {
        StreamSource skeleton = new StreamSource(new File(iso_tron));
        StreamSource schema = new StreamSource(new File(atom_tron));
        StringWriter temp = new StringWriter();
        StreamResult result = new StreamResult(temp);
        TransformerFactory factory = XmlTransformUtility.getTransformerFactory();
        Transformer xform = factory.newTransformer(skeleton);
        xform.transform(schema, result);
        temp.flush();
        temp.close();
        String stylesheet = temp.toString();
        StringReader in = new StringReader(stylesheet);
        StreamSource sheet = new StreamSource(in);
        Transformer validator = factory.newTransformer(sheet);
        validator.setOutputProperty("method", "text");
        temp = new StringWriter();
        result = new StreamResult(temp);
        validator.transform(new StreamSource(new StringReader(candidate)), result);
        temp.flush();
        String output = temp.toString();
        TestAtomDOSerializer.assertEquals((String)output, (String)"", (String)output);
    }

    private void setObjectDefaults(DigitalObject obj) {
        if (obj.getCreateDate() == null) {
            obj.setCreateDate(new Date());
        }
        Iterator dsIds = obj.datastreamIdIterator();
        while (dsIds.hasNext()) {
            String dsid = (String)dsIds.next();
            for (Datastream ds : obj.datastreams(dsid)) {
                if (ds.DSCreateDT != null) continue;
                ds.DSCreateDT = new Date();
            }
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestAtomDOSerializer.class);
    }
}

