/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.TestXMLDOSerializer;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public abstract class TestMETSFedoraExtDOSerializer
extends TestXMLDOSerializer {
    protected static final String ROOT_PATH = "/" + Constants.METS.METS.qName;
    protected static final String AMDSEC_PATH = ROOT_PATH + "/" + Constants.METS.AMD_SEC.qName;

    TestMETSFedoraExtDOSerializer(DOSerializer serializer) {
        super(serializer);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(Constants.METS.prefix, Constants.METS.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @Test
    public void testOBJIDAttribute() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathExists(ROOT_PATH + "[@OBJID='" + "test:pid" + "']", xml);
    }

    @Test
    public void testNoDatastreams() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathEvaluatesTo("1", "count(" + AMDSEC_PATH + ")", xml);
    }

    @Test
    public void testTwoInlineDatastreams() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestMETSFedoraExtDOSerializer.createXDatastream("DS1");
        String dsID2 = "DS2";
        DatastreamXMLMetadata ds2 = TestMETSFedoraExtDOSerializer.createXDatastream("DS2");
        obj.addDatastreamVersion((Datastream)ds1, true);
        obj.addDatastreamVersion((Datastream)ds2, true);
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathEvaluatesTo("3", "count(" + AMDSEC_PATH + ")", xml);
    }

    protected void doTestXLinkNamespace() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExtDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String url = "http://example.org/DS1";
        DatastreamReferencedContent ds = TestMETSFedoraExtDOSerializer.createRDatastream("DS1", "http://example.org/DS1");
        obj.addDatastreamVersion((Datastream)ds, true);
        Document xml = this.doSerializeOrFail(obj);
        String xpath = ROOT_PATH + "/" + Constants.METS.FILE_SEC.qName + "/" + Constants.METS.FILE_GRP.qName + "[@ID='DATASTREAMS']" + "/" + Constants.METS.FILE_GRP.qName + "[@ID='DS1']" + "/" + Constants.METS.FILE.qName + "/" + Constants.METS.FLOCAT.qName + "[@" + Constants.XLINK.HREF.qName + "='" + "http://example.org/DS1" + "']";
        this.assertXpathExists(xpath, xml);
    }
}

