/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.util.Date;
import org.fcrepo.utilities.DateUtility;
import org.junit.Assert;
import org.junit.Test;

public class TestDateUtility {
    protected final Date EPOCH = new Date(0L);
    protected final String EPOCH_DT = "1970-01-01T00:00:00.000Z";
    protected final String EPOCH_DT2 = "1970-01-01T00:00:00Z";
    protected final String EPOCH_XSD_DT = "1970-01-01T00:00:00Z";
    protected final String EPOCH_D = "1970-01-01Z";
    protected final String EPOCH_T = "00:00:00.000Z";
    protected final String HTTP_DATE = "Thu, 04 Aug 2005 01:35:07 GMT";
    protected final Date ONE_CE = new Date(-62135769600000L);
    protected final String ONE_CE_DT = "0001-01-01T00:00:00.000Z";
    protected final String ONE_CE_XSD_DT = "0001-01-01T00:00:00Z";
    protected final Date ONE_BCE = new Date(-62167392000000L);
    protected final String ONE_BCE_DT = "-0001-01-01T00:00:00.000Z";
    protected final String ONE_BCE_XSD_DT = "0000-01-01T00:00:00Z";
    protected final Date TWO_BCE = new Date(-62198928000000L);
    protected final String TWO_BCE_DT = "-0002-01-01T00:00:00.000Z";
    protected final String TWO_BCE_XSD_DT = "-0001-01-01T00:00:00Z";

    @Test
    public void testConvertDateToString() {
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)this.EPOCH));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)this.EPOCH, (boolean)true));
        Assert.assertEquals((Object)"1970-01-01T00:00:00Z", (Object)DateUtility.convertDateToString((Date)this.EPOCH, (boolean)false));
        Assert.assertEquals((Object)"0001-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)this.ONE_CE));
        Assert.assertEquals((Object)"-0001-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)this.ONE_BCE));
        Assert.assertEquals((Object)"-0002-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)this.TWO_BCE));
    }

    @Test
    public void testConvertDateToDateString() {
        Assert.assertEquals((Object)"1970-01-01Z", (Object)DateUtility.convertDateToDateString((Date)this.EPOCH));
    }

    @Test
    public void testConvertDateToTimeString() {
        Assert.assertEquals((Object)"00:00:00.000Z", (Object)DateUtility.convertDateToTimeString((Date)this.EPOCH));
    }

    @Test
    public void testConvertDateToXSDString() {
        Assert.assertEquals((Object)"1970-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)this.EPOCH));
        Assert.assertEquals((Object)"0001-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)this.ONE_CE));
        Assert.assertEquals((Object)"0000-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)this.ONE_BCE));
        Assert.assertEquals((Object)"-0001-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)this.TWO_BCE));
    }

    @Test
    public void testParseDate() {
        String[] badDates;
        String[] dates;
        for (String element : dates = new String[]{"1970-01-01T00:00:00.000Z", "1970-01-01T00:00:00.00Z", "1970-01-01T00:00:00.0Z", "1970-01-01T00:00:00Z", "1970-01-01Z", "1970-01-01T00:00:00.000", "1970-01-01T00:00:00.00", "1970-01-01T00:00:00.0", "1970-01-01T00:00:00", "1970-01-01", "Thu, 01 Jan 1970 00:00:00 GMT"}) {
            Assert.assertEquals((Object)this.EPOCH, (Object)DateUtility.parseDateLoose((String)element));
        }
        for (String element : badDates = new String[]{"", "ABCD-EF-GHTIJ:KL:MN.OPQZ", "1234", "1", "1970-01", "1970-1-1", "12345-01-01T00:00:00.000Z", "12345-01-01T00:00:00."}) {
            Assert.assertNull((String)(element + " not null"), (Object)DateUtility.parseDateLoose((String)element));
        }
        Assert.assertEquals((Object)this.ONE_CE, (Object)DateUtility.parseDateLoose((String)"0001-01-01T00:00:00Z"));
        Assert.assertEquals((Object)this.ONE_BCE, (Object)DateUtility.parseDateLoose((String)"0000-01-01T00:00:00Z"));
        Assert.assertEquals((Object)this.TWO_BCE, (Object)DateUtility.parseDateLoose((String)"-0001-01-01T00:00:00Z"));
    }

    @Test
    public void testMillis() throws Exception {
        String a = "1970-01-01T00:00:00.2Z";
        String b = "1970-01-01T00:00:00.200Z";
        Date aDate = DateUtility.parseDateStrict((String)a);
        Date bDate = DateUtility.parseDateStrict((String)b);
        Assert.assertEquals((long)200L, (long)aDate.getTime());
        Assert.assertEquals((long)200L, (long)bDate.getTime());
        Assert.assertEquals((Object)a, (Object)DateUtility.convertDateToXSDString((Date)aDate));
        Assert.assertEquals((Object)b, (Object)DateUtility.convertDateToString((Date)bDate));
        String c = "1970-01-01T00:00:00.02Z";
        String d = "1970-01-01T00:00:00.020Z";
        Date cDate = DateUtility.parseDateStrict((String)c);
        Date dDate = DateUtility.parseDateStrict((String)d);
        Assert.assertEquals((long)20L, (long)cDate.getTime());
        Assert.assertEquals((long)20L, (long)dDate.getTime());
        Assert.assertEquals((Object)c, (Object)DateUtility.convertDateToXSDString((Date)cDate));
        Assert.assertEquals((Object)d, (Object)DateUtility.convertDateToString((Date)dDate));
        String e = "1970-01-01T00:00:00.002Z";
        Date eDate = DateUtility.parseDateStrict((String)e);
        Assert.assertEquals((long)2L, (long)eDate.getTime());
        Assert.assertEquals((Object)e, (Object)DateUtility.convertDateToXSDString((Date)eDate));
        Assert.assertEquals((Object)e, (Object)DateUtility.convertDateToString((Date)eDate));
        String f = "1970-01-01T00:00:00.0Z";
        String g = "1970-01-01T00:00:00.00Z";
        Date fDate = DateUtility.parseDateStrict((String)f);
        Date gDate = DateUtility.parseDateStrict((String)g);
        Assert.assertEquals((long)0L, (long)fDate.getTime());
        Assert.assertEquals((long)0L, (long)gDate.getTime());
        Assert.assertEquals((Object)"1970-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)fDate));
        Assert.assertEquals((Object)"1970-01-01T00:00:00Z", (Object)DateUtility.convertDateToXSDString((Date)gDate));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)fDate));
        Assert.assertEquals((Object)"1970-01-01T00:00:00.000Z", (Object)DateUtility.convertDateToString((Date)gDate));
        String n = "-1234-01-01T00:00:00.2Z";
        String o = "-1234-01-01T00:00:00.200Z";
        Date nDate = DateUtility.parseDateStrict((String)n);
        Date oDate = DateUtility.parseDateStrict((String)o);
        Assert.assertEquals((long)nDate.getTime(), (long)oDate.getTime());
        Assert.assertEquals((Object)n, (Object)DateUtility.convertDateToXSDString((Date)nDate));
    }
}

