/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utilities;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.fcrepo.utilities.Base64;
import org.junit.Test;

public class TestBase64
extends TestCase {
    private static final byte[] FOO_BYTES = new byte[]{102, 111, 111};
    private static final byte[] FOO_BYTES_ENCODED = new byte[]{90, 109, 57, 118};
    private static final String FOO_STRING = "foo";
    private static final String FOO_STRING_ENCODED = "Zm9v";

    @Test
    public void testEncodeByteArray() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES_ENCODED, Base64.encode((byte[])FOO_BYTES)));
    }

    @Test
    public void testEncodeInputStream() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES_ENCODED, Base64.encode((InputStream)new ByteArrayInputStream(FOO_BYTES))));
    }

    @Test
    public void testEncodeToStringByteArray() {
        TestBase64.assertEquals((String)FOO_STRING_ENCODED, (String)Base64.encodeToString((byte[])FOO_BYTES));
    }

    @Test
    public void testEncodeToStringInputStream() {
        TestBase64.assertEquals((String)FOO_STRING_ENCODED, (String)Base64.encodeToString((InputStream)new ByteArrayInputStream(FOO_BYTES)));
    }

    @Test
    public void testDecodeByteArray() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES, Base64.decode((byte[])FOO_BYTES_ENCODED)));
    }

    @Test
    public void testDecodeString() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES, Base64.decode((String)FOO_STRING_ENCODED)));
    }

    @Test
    public void testDecodeToStringByteArray() {
        TestBase64.assertEquals((String)FOO_STRING, (String)Base64.decodeToString((byte[])FOO_BYTES_ENCODED));
    }

    private static final boolean sameBytes(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }
}

