/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import junit.framework.TestCase;
import org.fcrepo.utilities.FileUtils;
import org.fcrepo.utilities.Zip;

public class TestZip
extends TestCase {
    private final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private final String ZIP_FILE = this.TMP_DIR + File.separator + "test.zip";
    private final String TEST_DIR = this.TMP_DIR + File.separator + "test";

    protected void setUp() throws Exception {
        super.setUp();
        FileUtils.delete((String)this.TEST_DIR);
        File testDir = new File(this.TEST_DIR);
        File foo = new File(testDir, "foo");
        File bar = new File(testDir, "bar");
        File baz = new File(bar, "baz");
        File footxt = new File(foo, "foo.txt");
        File bartxt = new File(bar, "bar.txt");
        foo.mkdirs();
        baz.mkdirs();
        FileWriter fw = new FileWriter(footxt);
        fw.write("foo");
        fw.flush();
        fw.close();
        FileWriter bw = new FileWriter(bartxt);
        bw.write("bar");
        bw.flush();
        bw.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testZip() throws Exception {
        File dir = new File(this.TMP_DIR + File.separator + "test");
        Zip.zip((File)new File(this.ZIP_FILE), (File[])dir.listFiles());
    }

    public void testUnzip() throws Exception {
        FileInputStream fis = new FileInputStream(this.ZIP_FILE);
        Zip.unzip((InputStream)fis, (String)this.TEST_DIR);
        FileReader fr = new FileReader(this.TEST_DIR + File.separator + "foo" + File.separator + "foo.txt");
        BufferedReader buff = new BufferedReader(fr);
        boolean eof = false;
        while (!eof) {
            String line = buff.readLine();
            if (line == null) {
                eof = true;
                continue;
            }
            TestZip.assertEquals((String)"foo", (String)line);
        }
    }
}

