/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.StringReader;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.fcrepo.server.journal.JournalException;
import org.fcrepo.server.journal.JournalReader;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.ConsumerJournalEntry;
import org.fcrepo.server.journal.recoverylog.JournalRecoveryLog;

public class MockJournalReader
extends JournalReader {
    private static String buffer;
    private StringReader stringReader;
    private XMLEventReader xmlReader;

    public static void setBuffer(String buffer) {
        MockJournalReader.buffer = buffer;
    }

    public MockJournalReader(Map<String, String> parameters, String role, JournalRecoveryLog recoveryLog, ServerInterface server) throws JournalException {
        super(parameters, role, recoveryLog, server);
    }

    public ConsumerJournalEntry readJournalEntry() throws JournalException, XMLStreamException {
        this.prepareXmlReader();
        if (this.xmlReader == null) {
            return null;
        }
        this.advancePastWhitespace(this.xmlReader);
        XMLEvent next = this.xmlReader.peek();
        if (this.isStartTagEvent(next, QNAME_TAG_JOURNAL_ENTRY)) {
            ConsumerJournalEntry journalEntry = super.readJournalEntry(this.xmlReader);
            journalEntry.setIdentifier(new Date().toString());
            return journalEntry;
        }
        if (this.isEndTagEvent(next, QNAME_TAG_JOURNAL)) {
            return null;
        }
        throw this.getNotNextMemberOrEndOfGroupException(QNAME_TAG_JOURNAL, QNAME_TAG_JOURNAL_ENTRY, next);
    }

    public void shutdown() throws JournalException {
        try {
            if (this.xmlReader != null) {
                this.xmlReader.close();
            }
            if (this.stringReader != null) {
                this.stringReader.close();
            }
        }
        catch (XMLStreamException e) {
            throw new JournalException((Throwable)e);
        }
    }

    private void advanceIntoFile() throws XMLStreamException, JournalException {
        XMLEvent event = this.xmlReader.nextEvent();
        if (!event.isStartDocument()) {
            throw new JournalException("Expecting XML document header, but event was '" + event + "'");
        }
        event = this.xmlReader.nextTag();
        if (!this.isStartTagEvent(event, QNAME_TAG_JOURNAL)) {
            throw new JournalException("Expecting FedoraJournal start tag, but event was '" + event + "'");
        }
        String hash = this.getOptionalAttributeValue(event.asStartElement(), QNAME_ATTR_REPOSITORY_HASH);
        this.checkRepositoryHash(hash);
    }

    private void prepareXmlReader() throws JournalException {
        if (this.xmlReader != null) {
            return;
        }
        if (buffer == null || buffer.length() == 0) {
            return;
        }
        this.stringReader = new StringReader(buffer);
        try {
            this.xmlReader = XMLInputFactory.newInstance().createXMLEventReader(this.stringReader);
            this.advanceIntoFile();
        }
        catch (XMLStreamException e) {
            throw new JournalException((Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            throw new JournalException((Throwable)e);
        }
    }
}

