/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.journal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.JUnit4TestAdapter;
import org.fcrepo.common.Constants;
import org.fcrepo.common.rdf.RDFName;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.InvalidStateException;
import org.fcrepo.server.errors.ModuleInitializationException;
import org.fcrepo.server.errors.ModuleShutdownException;
import org.fcrepo.server.errors.ServerException;
import org.fcrepo.server.journal.JournalConsumer;
import org.fcrepo.server.journal.JournalCreator;
import org.fcrepo.server.journal.MockJournalReader;
import org.fcrepo.server.journal.MockJournalRecoveryLog;
import org.fcrepo.server.journal.MockJournalWriter;
import org.fcrepo.server.journal.MockServerForJournalTesting;
import org.fcrepo.server.journal.ServerInterface;
import org.fcrepo.server.journal.entry.JournalEntryContext;
import org.fcrepo.server.management.Management;
import org.fcrepo.server.management.ManagementDelegate;
import org.fcrepo.server.management.MockManagementDelegate;
import org.junit.Before;
import org.junit.Test;

public class TestJournalRoundTrip {
    private static final String METHOD_GET_TEMP_STREAM = "getTempStream";
    private static final String THE_ROLE = "theRole";
    private static final String THE_SERVER_HASH = "theServerHash";
    private Map<String, String> journalParameters;
    private JournalEntryContext leadingContext;
    private Map<RDFName, Object> contextAdditions;
    private JournalEntryContext expectedContext;
    private JournalCreator creator;
    private MockManagementDelegate leadingDelegate;
    private JournalConsumer consumer;
    MockManagementDelegate followingDelegate;
    private MockManagementDelegate.Call expectedCall;

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestJournalRoundTrip.class);
    }

    @Before
    public void initializeJournalParameters() {
        this.journalParameters = new HashMap<String, String>();
        this.journalParameters.put("journalWriterClassname", MockJournalWriter.class.getName());
        this.journalParameters.put("journalReaderClassname", MockJournalReader.class.getName());
        this.journalParameters.put("journalRecoveryLogClassname", MockJournalRecoveryLog.class.getName());
    }

    @Before
    public void initializeContextObjects() {
        this.leadingContext = new JournalEntryContext();
        this.expectedContext = null;
        this.contextAdditions = new HashMap<RDFName, Object>();
    }

    @Before
    public void initializeExpectedCall() {
        this.expectedCall = null;
    }

    @Test
    public void addDatastream() throws ServerException {
        this.expectInContext(Constants.RECOVERY.DATASTREAM_ID, "theDsId");
        this.testJournaledMethod("addDatastream", this.leadingContext, "thePid", "theDsId", new String[0], "theDsLabel", false, "theMIMEType", "theFormatURI", "theLocation", "theControlGroup", "theDsState", "theChecksumType", "theChecksum", "theLogMessage");
    }

    @Test
    public void addRelationship() throws ServerException {
        this.testJournaledMethod("addRelationship", this.leadingContext, "theSubject", "relationship", "anObject", false, "");
    }

    @Test
    public void compareDatastreamChecksum() throws ServerException {
        this.testNonJournaledMethod("compareDatastreamChecksum", this.leadingContext, "thePid", "theDsId", new Date(12345L));
    }

    @Test
    public void export() throws ServerException {
        this.testNonJournaledMethod("export", this.leadingContext, "PID", "format", "SomeExportContext", "encoding");
    }

    @Test
    public void getDatastream() throws ServerException {
        this.testNonJournaledMethod("getDatastream", this.leadingContext, "PID", "aDatastreamID", new Date());
    }

    @Test
    public void getDatastreamHistory() throws ServerException {
        this.testNonJournaledMethod("getDatastreamHistory", this.leadingContext, "PID", "anotherDatastreamID");
    }

    @Test
    public void getDatastreams() throws ServerException {
        this.testNonJournaledMethod("getDatastreams", this.leadingContext, "sonOfPID", new Date(111111L), "someStateString");
    }

    @Test
    public void getNextPID() throws ServerException {
        this.expectInContext(Constants.RECOVERY.PID_LIST, new String[]{"sillyPID_0", "sillyPID_1", "sillyPID_2", "sillyPID_3", "sillyPID_4"});
        this.testJournaledMethod("getNextPID", this.leadingContext, 5, "myFavoriteNamespace");
    }

    @Test
    public void getObjectXML() throws ServerException {
        this.testNonJournaledMethod("getObjectXML", this.leadingContext, "myPID", "encodingScheme");
    }

    @Test
    public void getRelationships() throws ServerException {
        this.testNonJournaledMethod("getRelationships", this.leadingContext, "mySubject", "someRelationship");
    }

    @Test
    public void getTempStream() throws ServerException {
        this.testNonJournaledMethod(METHOD_GET_TEMP_STREAM, "streamID");
    }

    @Test
    public void ingest() throws ServerException {
        this.expectInContext(Constants.RECOVERY.PID, "Ingest:1");
        this.testJournaledMethod("ingest", this.leadingContext, new ByteArrayInputStream(new byte[0]), "theLogMessage", "aFormat", "someEncoding", "new");
    }

    @Test
    public void modifyDatastreamByReference() throws ServerException {
        this.testJournaledMethod("modifyDatastreamByReference", this.leadingContext, "myPid", "datastreamIdentifier", new String[]{"altID"}, "datastreamLabel", "mime/type", "formatUri", "dsLocation", "checksumType", "checksum", "logMessage", new Date(253370761200L));
    }

    @Test
    public void modifyDatastreamByValue() throws ServerException {
        this.testJournaledMethod("modifyDatastreamByValue", this.leadingContext, "myPid", "datastreamIdentifier", new String[]{"altID"}, "datastreamLabel", "mime/type", "formatUri", new ByteArrayInputStream(new byte[0]), "checksumType", "checksum", "logMessage", new Date(253370761200L));
    }

    @Test
    public void modifyObject() throws ServerException {
        this.testJournaledMethod("modifyObject", this.leadingContext, "myPid", "state", "objectLabel", "owner", "logMessage", new Date(253370761200L));
    }

    @Test
    public void purgeDatastream() throws ServerException {
        this.testJournaledMethod("purgeDatastream", this.leadingContext, "myPid", "dsID", new Date(123L), new Date(456L), "logMessage");
    }

    @Test
    public void purgeObject() throws ServerException {
        this.testJournaledMethod("purgeObject", this.leadingContext, "aPID", "PurgeLogMessage");
    }

    @Test
    public void purgeRelationship() throws ServerException {
        this.testJournaledMethod("purgeRelationship", this.leadingContext, "aSubject", "theRelationship", "someObject", false, "datatype");
    }

    @Test
    public void putTempStream() throws ServerException {
        this.expectInContext(Constants.RECOVERY.UPLOAD_ID, "tempStreamId");
        this.testJournaledMethod("putTempStream", this.leadingContext, new ByteArrayInputStream(new byte[0]));
    }

    @Test
    public void setDatastreamState() throws ServerException {
        this.testJournaledMethod("setDatastreamState", this.leadingContext, "pid", "dsID", "dsState", "dsLogMessage");
    }

    @Test
    public void setDatastreamVersionable() throws ServerException {
        this.testJournaledMethod("setDatastreamVersionable", this.leadingContext, "lastPID", "lastDsID", true, "the Logger!");
    }

    private void expectInContext(RDFName key, Object value) {
        this.contextAdditions.put(key, value);
    }

    private void testJournaledMethod(String methodName, Object ... arguments) throws ServerException {
        this.buildExpectedCall(methodName, arguments);
        this.setupLeader();
        this.executeManagmentMethod((Management)this.creator, methodName, arguments);
        this.closeLeader();
        this.setupFollower();
        this.letFollowerCatchUp();
        this.assertExpectedCall("leading", this.leadingDelegate);
        this.assertExpectedCall("following", this.followingDelegate);
        try {
            this.executeManagmentMethod((Management)this.consumer, methodName, arguments);
            Assert.fail((String)"expected an InvalidStateException");
        }
        catch (InvalidStateException invalidStateException) {
            // empty catch block
        }
    }

    private void testNonJournaledMethod(String methodName, Object ... arguments) throws ServerException {
        this.buildExpectedCall(methodName, arguments);
        this.setupLeader();
        this.executeManagmentMethod((Management)this.creator, methodName, arguments);
        this.closeLeader();
        this.assertEmptyJournal();
        this.assertExpectedCall("leading", this.leadingDelegate);
        this.setupFollower();
        this.letFollowerCatchUp();
        this.executeManagmentMethod((Management)this.consumer, methodName, arguments);
        this.assertExpectedCall("following", this.followingDelegate);
    }

    private void buildExpectedCall(String methodName, Object[] arguments) {
        this.loadExpectedContext();
        if (arguments[0] == this.leadingContext) {
            arguments[0] = this.expectedContext;
        }
        this.expectedCall = new MockManagementDelegate.Call(methodName, arguments);
    }

    private void loadExpectedContext() {
        this.expectedContext = new JournalEntryContext((Context)this.leadingContext);
        for (Map.Entry<RDFName, Object> entry : this.contextAdditions.entrySet()) {
            try {
                this.expectedContext.getRecoveryAttributes().set(entry.getKey().uri, entry.getValue());
            }
            catch (Exception e) {
                Assert.fail((String)"Stupid design of MultiValueMap");
            }
        }
    }

    private void setupLeader() throws ModuleInitializationException {
        this.leadingDelegate = new MockManagementDelegate();
        MockServerForJournalTesting leadingServer = new MockServerForJournalTesting(this.leadingDelegate, THE_SERVER_HASH);
        this.creator = new JournalCreator(this.journalParameters, THE_ROLE, (ServerInterface)leadingServer);
        this.creator.setManagementDelegate((ManagementDelegate)this.leadingDelegate);
    }

    private void executeManagmentMethod(Management management, String methodName, Object[] arguments) throws ServerException {
        Class[] argTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argTypes[i] = this.getArgType(arguments[i]);
        }
        try {
            Method method = Management.class.getDeclaredMethod(methodName, argTypes);
            method.invoke((Object)management, arguments);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke the method: " + e));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke the method: " + e));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke the method: " + e));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke the method: " + e));
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ServerException) {
                throw (ServerException)cause;
            }
            e.printStackTrace();
            Assert.fail((String)("Failed to invoke the method: " + e));
        }
    }

    private Class<?> getArgType(Object argument) {
        Class<Object> argType;
        if (argument == null) {
            Assert.fail((String)"Can't run unit test with null arguments.");
        }
        if ((argType = argument.getClass()).equals(Integer.class)) {
            argType = Integer.TYPE;
        }
        if (argType.equals(Boolean.class)) {
            argType = Boolean.TYPE;
        }
        if (Context.class.isAssignableFrom(argType)) {
            argType = Context.class;
        }
        if (InputStream.class.isAssignableFrom(argType)) {
            argType = InputStream.class;
        }
        return argType;
    }

    private void closeLeader() throws ModuleShutdownException {
        this.creator.shutdown();
        MockJournalReader.setBuffer(MockJournalWriter.getBuffer());
    }

    public void setupFollower() throws ModuleInitializationException {
        this.followingDelegate = new MockManagementDelegate();
        MockServerForJournalTesting followingServer = new MockServerForJournalTesting(this.followingDelegate, THE_SERVER_HASH);
        this.consumer = new JournalConsumer(this.journalParameters, THE_ROLE, (ServerInterface)followingServer);
    }

    private void letFollowerCatchUp() throws ModuleShutdownException {
        this.consumer.setManagementDelegate((ManagementDelegate)this.followingDelegate);
        this.waitForConsumerThread();
        this.consumer.shutdown();
    }

    private void assertExpectedCall(String label, MockManagementDelegate delegate) {
        if (delegate.getCallCount() != 1) {
            Assert.fail((String)("Wrong number of " + label + " calls: expected 1, actual " + delegate.getCallCount() + ". Calls are as follows:\n" + delegate.getCalls()));
        }
        Assert.assertEquals((String)(label + " calls"), (Object)this.expectedCall, (Object)delegate.getCalls().get(0));
    }

    private void assertEmptyJournal() {
        Assert.assertEquals((String)"non-empty journal", (int)0, (int)MockJournalWriter.getBuffer().length());
    }

    private void waitForConsumerThread() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

