/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.messaging;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.fcrepo.server.messaging.JMSManager;

public class Listener
implements MessageListener {
    private final JMSManager jmsMgr;

    public Listener(String topicName, Properties jndiProps) throws Exception {
        this.jmsMgr = new JMSManager(jndiProps);
        System.out.println("*** Listening for messages on topic: " + topicName);
        this.jmsMgr.listen(topicName, (MessageListener)this);
    }

    public void onMessage(Message message) {
        try {
            TextMessage textMessage = (TextMessage)message;
            String text = textMessage.getText();
            System.out.println(text);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Usage: " + Listener.class.getName() + " jmsTopicName [providerURL]");
            System.out.println("\te.g. " + Class.class.getName() + " fedora.apim.update tcp://localhost:61616");
        }
        String topic = args[0];
        Properties jndiProps = null;
        if (args.length == 2) {
            jndiProps = new Properties();
            jndiProps.setProperty("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
            jndiProps.setProperty("java.naming.provider.url", args[1]);
            jndiProps.setProperty("topic." + topic, topic);
        }
        new Listener(topic, jndiProps);
    }
}

