/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.proxy;

import java.lang.reflect.Method;
import java.util.List;
import org.fcrepo.server.proxy.AbstractInvocationHandler;
import org.fcrepo.server.proxy.ProxyFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProxyFactoryTest {
    private TargetInterface target;

    @Before
    public void setUp() throws Exception {
        this.target = new TargetImpl();
    }

    @Test
    public void testGetProxy() throws Exception {
        Object[] chainA = new Object[]{new FlipBooleanHandler(), new ReverseStringHandler()};
        Object[] chainB = new Object[]{new ReverseStringHandler(), new PrefixStringWithXHandler()};
        Object[] chainC = new Object[]{new PrefixStringWithXHandler(), new ReverseStringHandler()};
        TargetInterface proxy = (TargetInterface)ProxyFactory.getProxy((Object)this.target, (Object[])chainA);
        Assert.assertTrue((boolean)proxy.bar(false));
        Assert.assertEquals((Object)"olleh", (Object)proxy.baz("hello"));
        proxy = (TargetInterface)ProxyFactory.getProxy((Object)this.target, (Object[])chainB);
        Assert.assertEquals((Object)"ollehX", (Object)proxy.baz("hello"));
        proxy = (TargetInterface)ProxyFactory.getProxy((Object)this.target, (Object[])chainC);
        Assert.assertEquals((Object)"Xolleh", (Object)proxy.baz("hello"));
    }

    class PrefixStringWithXHandler
    extends AbstractInvocationHandler {
        PrefixStringWithXHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String)) continue;
                args[i] = args[i] == null ? "X" : "X" + args[i];
            }
            Object returnValue = method.invoke(this.target, args);
            return returnValue;
        }
    }

    class ReverseStringHandler
    extends AbstractInvocationHandler {
        ReverseStringHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof String) || args[i] == null || args[i].equals("")) continue;
                StringBuilder sb = new StringBuilder((String)args[i]);
                args[i] = sb.reverse().toString();
            }
            Object returnValue = method.invoke(this.target, args);
            return returnValue;
        }
    }

    class FlipBooleanHandler
    extends AbstractInvocationHandler {
        FlipBooleanHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (int i = 0; i < args.length; ++i) {
                if (!(args[i] instanceof Boolean)) continue;
                Boolean b = (Boolean)args[i];
                args[i] = b == false;
            }
            Object returnValue = method.invoke(this.target, args);
            return returnValue;
        }
    }

    class TargetImpl
    implements TargetInterface {
        TargetImpl() {
        }

        @Override
        public void foo() {
        }

        @Override
        public boolean bar(boolean x) {
            return x;
        }

        @Override
        public String baz(String y) {
            return y;
        }

        @Override
        public List<String> quux(List<String> z) {
            return z;
        }
    }

    static interface TargetInterface {
        public void foo();

        public boolean bar(boolean var1);

        public String baz(String var1);

        public List<String> quux(List<String> var1);
    }
}

