/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.resourceIndex;

import java.util.HashSet;
import java.util.Set;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.fcrepo.server.resourceIndex.ResourceIndexIntegrationTest;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.ObjectBuilder;
import org.jrdf.graph.Triple;
import org.junit.Assert;

public class ResourceIndexModMiscIntegrationTest
extends ResourceIndexIntegrationTest {
    @org.junit.Test
    public void testModObjOnceLabelLv0() throws Exception {
        Set<DigitalObject> objects = ResourceIndexModMiscIntegrationTest.getTestObjects(1, 0);
        this.initRI(1);
        this.addAll(objects, true);
        Set<Triple> origTriples = this.getExpectedTriples(1, objects);
        DigitalObject original = (DigitalObject)objects.toArray()[0];
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        modified.setLabel("new label");
        this.initRI(0);
        this.modify(original, modified, true);
        Assert.assertTrue((String)"Did not get expected orig triples after modify at level 0", (boolean)this.sameTriples(origTriples, this.getActualTriples(), true));
    }

    @org.junit.Test
    public void testModObjOnceLabel() throws Exception {
        DigitalObject original = ResourceIndexModMiscIntegrationTest.getTestObject("test:1", "test1");
        DigitalObject modified = ObjectBuilder.deepCopy(original);
        modified.setLabel("new label");
        this.doModifyTest(1, original, modified);
    }

    @org.junit.Test
    public void testModObjMultiLabel() throws Exception {
        this.initRI(1);
        DigitalObject previous = ResourceIndexModMiscIntegrationTest.getTestObject("test:1", "test1");
        HashSet<DigitalObject> origSet = new HashSet<DigitalObject>();
        origSet.add(previous);
        this.addAll(origSet, true);
        for (int i = 1; i <= 5; ++i) {
            DigitalObject modified = ObjectBuilder.deepCopy(previous);
            modified.setLabel("new label " + i);
            this.doModifyTest(-1, previous, modified);
            previous = modified;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @org.junit.Test
    public void testModObjMultiLabelAsyncFlush() throws Exception {
        DigitalObject original;
        this.initRI(1);
        DigitalObject previous = original = ResourceIndexModMiscIntegrationTest.getTestObject("test:1", "test1");
        HashSet<DigitalObject> origSet = new HashSet<DigitalObject>();
        origSet.add(previous);
        this.addAll(origSet, true);
        Set<Triple> origTriples = this.getExpectedTriples(1, origSet);
        this.startFlushing(0);
        try {
            for (int i = 0; i <= 5; ++i) {
                DigitalObject modified = ObjectBuilder.deepCopy(previous);
                modified.setLabel("new label " + i);
                this.modify(previous, modified, false);
                previous = modified;
            }
            this.modify(previous, original, false);
        }
        finally {
            this.finishFlushing();
        }
        Assert.assertTrue((String)"Did not get expected orig triples after multi mod of one object with async buffer flushing", (boolean)this.sameTriples(origTriples, this.getActualTriples(), true));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(ResourceIndexModMiscIntegrationTest.class);
    }
}

