/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.lowlevel.akubra;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.JUnit4TestAdapter;
import org.akubraproject.BlobStore;
import org.akubraproject.mem.MemBlobStore;
import org.apache.commons.io.IOUtils;
import org.fcrepo.common.FaultException;
import org.fcrepo.server.errors.LowlevelStorageException;
import org.fcrepo.server.errors.ObjectAlreadyInLowlevelStorageException;
import org.fcrepo.server.errors.ObjectNotInLowlevelStorageException;
import org.fcrepo.server.storage.MockFedoraHintsProvider;
import org.fcrepo.server.storage.lowlevel.akubra.AkubraLowlevelStorage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AkubraLowlevelStorageTest {
    private static final String OBJ_KEY = "test:obj";
    private static final String OBJ_CONTENT = "obj-content";
    private static final String OBJ_CONTENT2 = "obj-content2";
    private static final String DS_KEY = "test:obj+DS+DS.0";
    private static final String DS_CONTENT = "ds-content";
    private static final String DS_CONTENT2 = "ds-content2";
    private AkubraLowlevelStorage instance;
    private AkubraLowlevelStorage safeInstance;

    @Before
    public void setUp() {
        this.instance = AkubraLowlevelStorageTest.getInstance(false, false);
        this.safeInstance = AkubraLowlevelStorageTest.getInstance(true, true);
    }

    @Test(expected=ObjectAlreadyInLowlevelStorageException.class)
    public void testAddExistingDatastream() throws LowlevelStorageException {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
    }

    @Test(expected=ObjectAlreadyInLowlevelStorageException.class)
    public void testAddExistingObject() throws LowlevelStorageException {
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
    }

    @Test
    public void testAddNonExistingDatastream() throws Exception {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
    }

    @Test
    public void testAddNonExistingObject() throws Exception {
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
    }

    @Test
    public void testAuditDatastream() throws Exception {
        this.instance.auditDatastream();
    }

    @Test
    public void testAuditObject() throws Exception {
        this.instance.auditObject();
    }

    @Test
    public void testRebuildDatastream() throws Exception {
        this.instance.rebuildDatastream();
    }

    @Test
    public void testRebuildObject() throws Exception {
        this.instance.rebuildObject();
    }

    @Test
    public void testRemoveExistingDatastream() throws Exception {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        this.instance.removeDatastream(DS_KEY);
    }

    @Test
    public void testRemoveExistingObject() throws Exception {
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        this.instance.removeObject(OBJ_KEY);
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testRemoveNonExistingDatastream() throws Exception {
        this.instance.removeDatastream(DS_KEY);
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testRemoveNonExistingObject() throws Exception {
        this.instance.removeObject(OBJ_KEY);
    }

    @Test
    public void testReplaceExistingDatastream() throws Exception {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        this.instance.replaceDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT2));
        List<String> list = AkubraLowlevelStorageTest.toList(this.instance.listDatastreams());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)DS_CONTENT2, (Object)AkubraLowlevelStorageTest.toString(this.instance.retrieveDatastream(DS_KEY)));
    }

    @Test
    public void testReplaceExistingDatastreamSafely() throws Exception {
        this.safeInstance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        this.safeInstance.replaceDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT2));
        List<String> list = AkubraLowlevelStorageTest.toList(this.safeInstance.listDatastreams());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)DS_CONTENT2, (Object)AkubraLowlevelStorageTest.toString(this.safeInstance.retrieveDatastream(DS_KEY)));
    }

    @Test
    public void testReplaceExistingObject() throws Exception {
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        this.instance.replaceObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT2));
        List<String> list = AkubraLowlevelStorageTest.toList(this.instance.listObjects());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)OBJ_CONTENT2, (Object)AkubraLowlevelStorageTest.toString(this.instance.retrieveObject(OBJ_KEY)));
    }

    @Test
    public void testReplaceExistingObjectSafely() throws Exception {
        this.safeInstance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        this.safeInstance.replaceObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT2));
        List<String> list = AkubraLowlevelStorageTest.toList(this.safeInstance.listObjects());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)OBJ_CONTENT2, (Object)AkubraLowlevelStorageTest.toString(this.safeInstance.retrieveObject(OBJ_KEY)));
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testReplaceNonExistingDatastream() throws Exception {
        this.instance.replaceDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testReplaceNonExistingDatastreamSafely() throws Exception {
        this.safeInstance.replaceDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testReplaceNonExistingObject() throws Exception {
        this.instance.replaceObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testReplaceNonExistingObjectSafely() throws Exception {
        this.safeInstance.replaceObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
    }

    @Test
    public void testRetrieveExistingDatastream() throws Exception {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        Assert.assertEquals((Object)DS_CONTENT, (Object)AkubraLowlevelStorageTest.toString(this.instance.retrieveDatastream(DS_KEY)));
    }

    @Test
    public void testRetrieveExistingObject() throws Exception {
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        Assert.assertEquals((Object)OBJ_CONTENT, (Object)AkubraLowlevelStorageTest.toString(this.instance.retrieveObject(OBJ_KEY)));
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testRetrieveNonExistingDatastream() throws Exception {
        this.instance.retrieveDatastream(DS_KEY);
    }

    @Test(expected=ObjectNotInLowlevelStorageException.class)
    public void testRetrieveNonExistingObject() throws Exception {
        this.instance.retrieveDatastream(OBJ_KEY);
    }

    @Test
    public void testListDatastreams() throws Exception {
        List<String> list = AkubraLowlevelStorageTest.toList(this.instance.listDatastreams());
        Assert.assertEquals((long)0L, (long)list.size());
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        list = AkubraLowlevelStorageTest.toList(this.instance.listDatastreams());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)DS_KEY, (Object)list.get(0));
        this.instance.removeDatastream(DS_KEY);
        list = AkubraLowlevelStorageTest.toList(this.instance.listDatastreams());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testListObjects() throws Exception {
        List<String> list = AkubraLowlevelStorageTest.toList(this.instance.listObjects());
        Assert.assertEquals((long)0L, (long)list.size());
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT));
        list = AkubraLowlevelStorageTest.toList(this.instance.listObjects());
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)OBJ_KEY, (Object)list.get(0));
        this.instance.removeObject(OBJ_KEY);
        list = AkubraLowlevelStorageTest.toList(this.instance.listObjects());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testGetDatastreamSize() throws Exception {
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT));
        Assert.assertEquals((long)DS_CONTENT.getBytes("UTF-8").length, (long)this.instance.getDatastreamSize(DS_KEY));
    }

    @Test
    public void testAddDatastreamWithHints() throws Exception {
        MockFedoraHintsProvider provider = new MockFedoraHintsProvider();
        Map hints = provider.getHintsForAboutToBeStoredDatastream(null, null);
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT), hints);
    }

    @Test
    public void testReplaceDatastreamWithHints() throws Exception {
        MockFedoraHintsProvider provider = new MockFedoraHintsProvider();
        Map hints = provider.getHintsForAboutToBeStoredDatastream(null, null);
        this.instance.addDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT), hints);
        this.instance.replaceDatastream(DS_KEY, AkubraLowlevelStorageTest.toStream(DS_CONTENT), hints);
    }

    @Test
    public void testAddObjectWithHints() throws Exception {
        MockFedoraHintsProvider provider = new MockFedoraHintsProvider();
        Map hints = provider.getHintsForAboutToBeStoredObject(null);
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT), hints);
    }

    @Test
    public void testReplaceObjectWithHints() throws Exception {
        MockFedoraHintsProvider provider = new MockFedoraHintsProvider();
        Map hints = provider.getHintsForAboutToBeStoredObject(null);
        this.instance.addObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT), hints);
        this.instance.replaceObject(OBJ_KEY, AkubraLowlevelStorageTest.toStream(OBJ_CONTENT), hints);
    }

    private static AkubraLowlevelStorage getInstance(boolean forceSafeObjectOverwrites, boolean forceSafeDatastreamOverwrites) {
        return new AkubraLowlevelStorage((BlobStore)new MemBlobStore(), (BlobStore)new MemBlobStore(), forceSafeObjectOverwrites, forceSafeDatastreamOverwrites);
    }

    private static List<String> toList(Iterator<String> iter) {
        ArrayList<String> list = new ArrayList<String>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private static InputStream toStream(String string) {
        try {
            return new ByteArrayInputStream(string.getBytes("UTF-8"));
        }
        catch (IOException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
    }

    private static String toString(InputStream stream) {
        try {
            String string = new BufferedReader(new InputStreamReader(stream)).readLine();
            return string;
        }
        catch (IOException wontHappen) {
            throw new FaultException((Throwable)wontHappen);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(AkubraLowlevelStorageTest.class);
    }
}

