/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.fcrepo.common.Constants;
import org.fcrepo.common.Models;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.METSFedoraExt1_1DOSerializer;
import org.fcrepo.server.storage.translation.TestMETSFedoraExtDOSerializer;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.URIReference;
import org.junit.After;
import org.junit.Before;
import org.w3c.dom.Document;

public class TestMETSFedoraExt1_1DOSerializer
extends TestMETSFedoraExtDOSerializer {
    public TestMETSFedoraExt1_1DOSerializer() {
        super((DOSerializer)new METSFedoraExt1_1DOSerializer());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(Constants.METS.prefix, Constants.METS.uri);
        nsMap.put(Constants.XLINK.prefix, Constants.XLINK.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ctx);
    }

    @Override
    @After
    public void tearDown() {
        XMLUnit.setXpathNamespaceContext((NamespaceContext)SimpleNamespaceContext.EMPTY_CONTEXT);
    }

    @org.junit.Test
    public void testXLinkNamespace() throws TransformerException, XpathException {
        this.doTestXLinkNamespace();
    }

    @org.junit.Test
    public void testVersionAttribute() throws TransformerException, XpathException {
        DigitalObject obj = TestMETSFedoraExt1_1DOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        Document xml = this.doSerializeOrFail(obj);
        this.assertXpathExists(ROOT_PATH + "[@EXT_VERSION = '1.1']", xml);
    }

    @org.junit.Test
    public void testSerializeSimpleCModelObject() {
        this.doSerializeAllOrFail(TestMETSFedoraExt1_1DOSerializer.createTestObject(new URIReference[]{Models.CONTENT_MODEL_3_0}));
    }

    public static Test suite() {
        return new JUnit4TestAdapter(TestMETSFedoraExt1_1DOSerializer.class);
    }
}

