/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.custommonkey.xmlunit.XMLUnit;
import org.fcrepo.common.Models;
import org.fcrepo.server.errors.ObjectIntegrityException;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.translation.DOSerializer;
import org.fcrepo.server.storage.translation.TranslationTest;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.URIReference;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class TestXMLDOSerializer
extends TranslationTest {
    protected final DOSerializer m_serializer;

    TestXMLDOSerializer(DOSerializer serializer) {
        this.m_serializer = serializer;
    }

    @Test
    public void testSerializeSimpleDataObject() {
        this.doSerializeAllOrFail(TestXMLDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0}));
    }

    @Test
    public void testSerializeSimpleSDepObject() {
        this.doSerializeAllOrFail(TestXMLDOSerializer.createTestObject(new URIReference[]{Models.SERVICE_DEPLOYMENT_3_0}));
    }

    @Test
    public void testSerializeSimpleSDefObject() {
        this.doSerializeAllOrFail(TestXMLDOSerializer.createTestObject(new URIReference[]{Models.SERVICE_DEFINITION_3_0}));
    }

    @Test
    public void testInlineXMLEncoding() throws Exception {
        String TAG = "test";
        String OPEN = "<test>";
        String CLOSE = "</test>";
        char[] unicodeContent = new char[1365];
        StringBuilder payload = new StringBuilder(unicodeContent.length + "<test>".length() + "</test>".length());
        for (int i = 0; i < unicodeContent.length; ++i) {
            unicodeContent[i] = 3671;
        }
        payload.append("<test>");
        payload.append(unicodeContent);
        payload.append("</test>");
        DigitalObject obj = TestXMLDOSerializer.createTestObject(new URIReference[]{Models.FEDORA_OBJECT_3_0});
        String dsID1 = "DS1";
        DatastreamXMLMetadata ds1 = TestXMLDOSerializer.createXDatastream("DS1");
        ds1.xmlContent = payload.toString().getBytes("UTF-8");
        obj.addDatastreamVersion((Datastream)ds1, true);
        String serializedContent = this.doSerialize(obj, 3).getElementsByTagName("test").item(0).getFirstChild().getNodeValue();
        TestXMLDOSerializer.assertTrue((String)"UTF-8 chars are not serialized properly!", (boolean)new String(unicodeContent).equals(serializedContent));
    }

    protected void doSerializeAllOrFail(DigitalObject obj) {
        this.doSerializeOrFail(obj, 4);
        this.doSerializeOrFail(obj, 2);
        this.doSerializeOrFail(obj, 1);
        this.doSerializeOrFail(obj, 3);
    }

    protected Document doSerializeOrFail(DigitalObject obj) {
        return this.doSerializeOrFail(obj, 3);
    }

    protected Document doSerializeOrFail(DigitalObject obj, int transContext) {
        Document result = null;
        try {
            result = this.doSerialize(obj, transContext);
        }
        catch (ObjectIntegrityException e) {
            e.printStackTrace();
            TestXMLDOSerializer.fail((String)"Serializer threw ObjectIntegrityException");
        }
        catch (SAXException e) {
            e.printStackTrace();
            TestXMLDOSerializer.fail((String)"Serialized XML was not well-formed");
        }
        return result;
    }

    protected Document doSerialize(DigitalObject obj, int transContext) throws ObjectIntegrityException, SAXException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.m_serializer.serialize(obj, (OutputStream)out, "UTF-8", transContext);
        }
        catch (StreamIOException e) {
            TestXMLDOSerializer.fail((String)"Serializer threw StreamIOException");
        }
        catch (UnsupportedEncodingException e) {
            TestXMLDOSerializer.fail((String)"Serializer doesn't support UTF-8!?");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        try {
            return XMLUnit.buildControlDocument((InputSource)new InputSource(in));
        }
        catch (SAXException notWellFormed) {
            throw notWellFormed;
        }
        catch (IOException wontHappen) {
            throw new Error(wontHappen);
        }
    }
}

