/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.translation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.custommonkey.xmlunit.XMLTestCase;
import org.fcrepo.common.PID;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.StreamIOException;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.DSBinding;
import org.fcrepo.server.storage.types.DSBindingMap;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.fcrepo.server.storage.types.Disseminator;
import org.jrdf.graph.URIReference;
import org.junit.Before;

public abstract class TranslationTest
extends XMLTestCase {
    protected static final String TEST_PID = "test:pid";

    @Before
    public void setUp() {
        System.setProperty("fedoraServerHost", "localhost");
        System.setProperty("fedoraServerPort", "8080");
        System.setProperty("fedoraAppServerContext", "fedora");
    }

    protected static DigitalObject createTestObject(URIReference ... contentModelURIs) {
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setPid(TEST_PID);
        DatastreamXMLMetadata ds = TranslationTest.createXDatastream("RELS-EXT");
        StringBuilder rdf = new StringBuilder();
        rdf.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\">\n<rdf:Description rdf:about=\"");
        rdf.append(PID.getInstance((String)TEST_PID).toURI() + "\">\n");
        for (URIReference model : contentModelURIs) {
            rdf.append("<fedora-model:hasModel rdf:resource=\"" + model.getURI().toString() + "\"></fedora-model:hasModel>\n");
        }
        rdf.append("</rdf:Description></rdf:RDF>");
        ds.xmlContent = rdf.toString().getBytes();
        obj.addDatastreamVersion((Datastream)ds, false);
        obj.setCreateDate(new Date());
        obj.setLastModDate(new Date());
        obj.setCreateDate(new Date());
        obj.setLastModDate(new Date());
        return obj;
    }

    protected static DatastreamXMLMetadata createXDatastream(String id) {
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        ds.DatastreamID = id;
        ds.DSVersionID = id + ".0";
        ds.DSControlGrp = "X";
        ds.xmlContent = "<doc/>".getBytes();
        ds.DSCreateDT = new Date();
        return ds;
    }

    protected static DatastreamReferencedContent createRDatastream(String id, String url) {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        ds.DatastreamID = id;
        ds.DSVersionID = id + ".0";
        ds.DSControlGrp = "R";
        ds.DSLocation = url;
        return ds;
    }

    protected static DatastreamManagedContent createMDatastream(String id, final byte[] content) {
        DatastreamManagedContent dmc = new DatastreamManagedContent(){

            public InputStream getContentStream(Context ctx) throws StreamIOException {
                return new ByteArrayInputStream(content);
            }
        };
        dmc.DatastreamID = id;
        dmc.DSVersionID = id + ".0";
        dmc.DSControlGrp = "M";
        dmc.DSChecksumType = "MD5";
        dmc.DSChecksum = DigestUtils.md5Hex((byte[])content);
        return dmc;
    }

    protected static Disseminator createDisseminator(String id, int numBindings) {
        Disseminator diss = new Disseminator();
        diss.dissID = id;
        diss.dissVersionID = id + ".0";
        diss.bDefID = "test:pidbdef";
        diss.sDepID = "test:pidbmech";
        diss.dsBindMap = new DSBindingMap();
        diss.dsBindMapID = id + "bindMap";
        DSBinding[] dsBindings = new DSBinding[numBindings];
        for (int i = 1; i <= numBindings; ++i) {
            dsBindings[i - 1] = new DSBinding();
            dsBindings[i - 1].bindKeyName = "KEY" + i;
            dsBindings[i - 1].datastreamID = "DS" + i;
        }
        diss.dsBindMap.dsBindings = dsBindings;
        return diss;
    }
}

