/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.storage.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.fcrepo.common.Models;
import org.fcrepo.common.PID;
import org.fcrepo.server.storage.translation.FOXML1_1DODeserializer;
import org.fcrepo.server.storage.translation.FOXML1_1DOSerializer;
import org.fcrepo.server.storage.types.BasicDigitalObject;
import org.fcrepo.server.storage.types.Datastream;
import org.fcrepo.server.storage.types.DatastreamManagedContent;
import org.fcrepo.server.storage.types.DatastreamReferencedContent;
import org.fcrepo.server.storage.types.DatastreamXMLMetadata;
import org.fcrepo.server.storage.types.DigitalObject;
import org.jrdf.graph.URIReference;

public abstract class ObjectBuilder {
    public static void addEDatastream(DigitalObject obj, String id) {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        ds.DSControlGrp = "E";
        ds.DSMIME = "text/plain";
        ds.DSLocation = "http://www.example.org/e.txt";
        ds.DSLocationType = "URL";
        ds.DSSize = 1L;
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    public static void addEDatastream(DigitalObject obj, String id, String url, String mime) {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        ds.DSControlGrp = "E";
        ds.DSMIME = mime;
        ds.DSLocation = url;
        ds.DSLocationType = "URL";
        ds.DSSize = 1L;
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    public static void addRDatastream(DigitalObject obj, String id) {
        DatastreamReferencedContent ds = new DatastreamReferencedContent();
        ds.DSControlGrp = "R";
        ds.DSMIME = "text/plain";
        ds.DSLocation = "http://www.example.org/r.txt";
        ds.DSLocationType = "URL";
        ds.DSSize = 2L;
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    public static void addXDatastream(DigitalObject obj, String id, String xml) {
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        ds.DSControlGrp = "X";
        ds.DSMIME = "text/xml";
        ds.DSSize = xml.length();
        try {
            ds.xmlContent = xml.getBytes("UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    public static void addXDatastream(DigitalObject obj, String id, String xml, String formatURI) {
        DatastreamXMLMetadata ds = new DatastreamXMLMetadata();
        ds.DSControlGrp = "X";
        ds.DSMIME = "text/xml";
        ds.DSFormatURI = formatURI;
        ds.DSSize = xml.length();
        try {
            ds.xmlContent = xml.getBytes("UTF-8");
        }
        catch (Exception e) {
            // empty catch block
        }
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    public static void addMDatastream(DigitalObject obj, String id) {
        DatastreamManagedContent ds = new DatastreamManagedContent();
        ds.DSControlGrp = "M";
        ds.DSMIME = "image/jpeg";
        ds.DSLocation = "bogusLocation";
        ds.DSLocationType = "INTERNAL_ID";
        ds.DSSize = 4L;
        ObjectBuilder.addDatastream(obj, id, (Datastream)ds);
    }

    private static void addDatastream(DigitalObject obj, String id, Datastream ds) {
        int size = 0;
        for (Datastream d : obj.datastreams(id)) {
            ++size;
        }
        ds.DatastreamID = id;
        ds.DSState = "A";
        ds.DSVersionable = true;
        ds.DSVersionID = id + "." + size;
        ds.DSLabel = "ds label";
        ds.DSCreateDT = new Date();
        obj.addDatastreamVersion(ds, true);
    }

    public static DigitalObject getTestObject(String pid, String label) {
        Date now = new Date();
        URIReference[] models = new URIReference[]{Models.FEDORA_OBJECT_3_0};
        return ObjectBuilder.getTestObject(pid, models, "A", "someOwnerId", label, now, now);
    }

    public static DigitalObject getTestObject(String pid, URIReference[] models, String state, String ownerId, String label, Date createDate, Date lastModDate) {
        BasicDigitalObject obj = new BasicDigitalObject();
        obj.setPid(pid);
        StringBuilder rdf = new StringBuilder();
        rdf.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:fedora-model=\"info:fedora/fedora-system:def/model#\">\n<rdf:Description rdf:about=\"");
        rdf.append(PID.getInstance((String)pid).toURI() + "\">\n");
        for (URIReference model : models) {
            rdf.append("<fedora-model:hasModel rdf:resource=\"" + model.getURI().toString() + "\"></fedora-model:hasModel>\n");
        }
        rdf.append("</rdf:Description></rdf:RDF>");
        ObjectBuilder.addXDatastream((DigitalObject)obj, "RELS-EXT", rdf.toString());
        obj.setState(state);
        obj.setOwnerId(ownerId);
        obj.setLabel(label);
        obj.setCreateDate(createDate);
        obj.setLastModDate(lastModDate);
        return obj;
    }

    public static DigitalObject deepCopy(DigitalObject obj) throws Exception {
        if (System.getProperty("fedoraServerHost") == null || System.getProperty("fedoraServerPort") == null) {
            System.setProperty("fedoraServerHost", "localhost");
            System.setProperty("fedoraServerPort", "8080");
        }
        String charEncoding = "UTF-8";
        int transContext = 3;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FOXML1_1DOSerializer ser = new FOXML1_1DOSerializer();
        ser.serialize(obj, (OutputStream)out, charEncoding, transContext);
        FOXML1_1DODeserializer deser = new FOXML1_1DODeserializer();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        BasicDigitalObject objCopy = new BasicDigitalObject();
        deser.deserialize((InputStream)in, (DigitalObject)objCopy, charEncoding, transContext);
        try {
            Thread.sleep(100L);
        }
        catch (Exception e) {
            // empty catch block
        }
        return objCopy;
    }

    public static String getDC(String content) {
        StringBuffer x = new StringBuffer();
        x.append("<oai_dc:dc xmlns:dc=\"http://purl.org/dc/elements/1.1/\"");
        x.append(" xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\">\n");
        x.append(content + "\n");
        x.append("</oai_dc:dc>");
        return x.toString();
    }

    public static String getRELSEXT(String pid, String content) {
        StringBuffer x = new StringBuffer();
        x.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        x.append(" xmlns:foo=\"http://example.org/foo#\">\n");
        x.append("<rdf:Description rdf:about=\"" + PID.getInstance((String)pid).toURI() + "\">\n");
        x.append(content + "\n");
        x.append("</rdf:Description>\n");
        x.append("</rdf:RDF>");
        return x.toString();
    }

    public static String getRELSINT(String pid, String content1, String content2) {
        StringBuffer x = new StringBuffer();
        x.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"");
        x.append(" xmlns:foo=\"http://example.org/foo#\">\n");
        x.append("<rdf:Description rdf:about=\"" + PID.getInstance((String)pid).toURI() + "/DS1" + "\">\n");
        x.append(content1 + "\n");
        x.append("</rdf:Description>\n");
        x.append("<rdf:Description rdf:about=\"" + PID.getInstance((String)pid).toURI() + "/DS2" + "\">\n");
        x.append(content2 + "\n");
        x.append("</rdf:Description>\n");
        x.append("</rdf:RDF>");
        return x.toString();
    }

    public static void setDates(DigitalObject obj, Date date) {
        if (obj.getCreateDate() == null) {
            obj.setCreateDate(date);
        }
        Iterator dsIds = obj.datastreamIdIterator();
        while (dsIds.hasNext()) {
            String dsid = (String)dsIds.next();
            for (Datastream ds : obj.datastreams(dsid)) {
                if (ds.DSCreateDT != null) continue;
                ds.DSCreateDT = new Date();
            }
        }
    }
}

