/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.server.utilities;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.fcrepo.common.Constants;
import org.fcrepo.server.utilities.DCFields;
import org.junit.Test;
import org.w3c.dom.Document;

public class DCFieldsTest
extends XMLTestCase {
    private static final String dcWithXmlLang;
    private XpathEngine engine;

    public void setUp() throws Exception {
        HashMap<String, String> nsMap = new HashMap<String, String>();
        nsMap.put(Constants.OAI_DC.prefix, Constants.OAI_DC.uri);
        nsMap.put(Constants.DC.prefix, Constants.DC.uri);
        SimpleNamespaceContext ctx = new SimpleNamespaceContext(nsMap);
        this.engine = XMLUnit.newXpathEngine();
        this.engine.setNamespaceContext((NamespaceContext)ctx);
    }

    @Test
    public void testDCFieldsInputStream() throws Exception {
        DCFields dc = new DCFields((InputStream)new ByteArrayInputStream(dcWithXmlLang.getBytes("UTF-8")));
        Document dcXML = XMLUnit.buildControlDocument((String)dc.getAsXML());
        DCFieldsTest.assertEquals((String)"Time interval", (String)this.engine.evaluate("//dc:subject[@xml:lang='en']", dcXML));
        DCFieldsTest.assertEquals((String)"Tidsinterval", (String)this.engine.evaluate("//dc:subject[@xml:lang='da']", dcXML));
        dc = new DCFields();
        dcXML = XMLUnit.buildControlDocument((String)dc.getAsXML());
        DCFieldsTest.assertEquals((String)"Expected empty element", (String)"", (String)this.engine.evaluate("//oai_dc:dc", dcXML).trim());
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("<oai_dc:dc xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\" ");
        sb.append("    xmlns:dc=\"http://purl.org/dc/elements/1.1/\">");
        sb.append("<dc:subject xml:lang=\"da\">Tidsinterval</dc:subject>");
        sb.append("<dc:subject xml:lang=\"en\">Time interval</dc:subject>");
        sb.append("<dc:subject>interval</dc:subject>");
        sb.append("</oai_dc:dc> ");
        dcWithXmlLang = sb.toString();
    }
}

