/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.utilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.fcrepo.utilities.Base64;
import org.junit.Test;

public class TestBase64
extends TestCase {
    public static final byte[] FOO_BYTES = new byte[]{102, 111, 111};
    public static final byte[] FOO_BYTES_ENCODED = new byte[]{90, 109, 57, 118};
    public static final String FOO_STRING = "foo";
    public static final String FOO_STRING_ENCODED = "Zm9v";

    @Test
    public void testEncodeByteArray() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES_ENCODED, Base64.encode((byte[])FOO_BYTES)));
    }

    @Test
    public void testEncodeInputStream() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES_ENCODED, Base64.encode((InputStream)new ByteArrayInputStream(FOO_BYTES))));
    }

    @Test
    public void testEncodeToStringByteArray() {
        TestBase64.assertEquals((String)FOO_STRING_ENCODED, (String)Base64.encodeToString((byte[])FOO_BYTES));
    }

    @Test
    public void testEncodeToStreamInputStream() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteArrayInputStream bis = new ByteArrayInputStream(FOO_BYTES);
        InputStream encoded = Base64.encodeToStream((InputStream)bis);
        int read = -1;
        while ((read = encoded.read()) > -1) {
            bos.write(read);
        }
        byte[] actual = bos.toByteArray();
        TestBase64.assertSameBytes(FOO_BYTES_ENCODED, actual);
    }

    @Test
    public void testEncodeToStringInputStream() {
        TestBase64.assertEquals((String)FOO_STRING_ENCODED, (String)Base64.encodeToString((InputStream)new ByteArrayInputStream(FOO_BYTES)));
    }

    @Test
    public void testDecodeByteArray() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES, Base64.decode((byte[])FOO_BYTES_ENCODED)));
    }

    @Test
    public void testDecodeString() {
        TestBase64.assertTrue((boolean)TestBase64.sameBytes(FOO_BYTES, Base64.decode((String)FOO_STRING_ENCODED)));
    }

    @Test
    public void testDecodeToStringByteArray() {
        TestBase64.assertEquals((String)FOO_STRING, (String)Base64.decodeToString((byte[])FOO_BYTES_ENCODED));
    }

    private static final boolean sameBytes(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static final void assertSameBytes(byte[] a, byte[] b) {
        if (a.length != b.length) {
            TestBase64.fail((String)("Bytes not equal\nE: " + TestBase64.inspectBytes(a) + "\nA: " + TestBase64.inspectBytes(b)));
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            TestBase64.fail((String)("Bytes not equal at position " + Integer.toString(i) + "\nE: " + TestBase64.inspectBytes(a) + "\nA: " + TestBase64.inspectBytes(b)));
        }
    }

    private static String inspectBytes(byte[] a) {
        StringBuilder builder = new StringBuilder(a.length * 3);
        for (byte b : a) {
            builder.append(Integer.toHexString(b));
            builder.append(' ');
        }
        return builder.toString();
    }
}

