/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.oai;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fcrepo.common.Constants;
import org.fcrepo.oai.OAIException;
import org.fcrepo.oai.OAIResponder;
import org.fcrepo.oai.RepositoryException;
import org.fcrepo.server.ReadOnlyContext;
import org.fcrepo.server.errors.authorization.AuthzDeniedException;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.errors.authorization.AuthzOperationalException;
import org.fcrepo.server.errors.authorization.AuthzPermittedException;
import org.fcrepo.server.errors.servletExceptionExtensions.InternalError500Exception;
import org.fcrepo.server.errors.servletExceptionExtensions.RootException;

public abstract class OAIProviderServlet
extends HttpServlet {
    public static final String ACTION_LABEL = "OAI";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration enm = request.getParameterNames();
            while (enm.hasMoreElements()) {
                String name = (String)enm.nextElement();
                params.put(name, request.getParameter(name));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, request);
            try {
                this.getResponder().respond(context, params, out);
            }
            catch (AuthzException ae) {
                throw RootException.getServletException(ae, request, ACTION_LABEL, new String[0]);
            }
            response.setContentType("text/xml; charset=UTF-8");
            response.getWriter().print(new String(out.toByteArray(), "UTF-8"));
        }
        catch (Throwable t) {
            throw new InternalError500Exception("", t, request, ACTION_LABEL, "", new String[0]);
        }
    }

    private static String getMessage(Throwable t) {
        String msg = t.getMessage();
        if (msg == null) {
            msg = "Unexpected repository error.";
        }
        return msg;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void test(String[] args) throws OAIException, RepositoryException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ReadOnlyContext context = ReadOnlyContext.getContext(Constants.HTTP_REQUEST.REST.uri, null);
        try {
            this.getResponder().respond(context, OAIProviderServlet.getAsParameterMap(args), out);
        }
        catch (AuthzOperationalException aoe) {
            System.out.println("403 - operational");
        }
        catch (AuthzDeniedException ade) {
            System.out.println("403");
        }
        catch (AuthzPermittedException ape) {
            System.out.println("100");
        }
        catch (AuthzException ae) {
            System.out.println("403 - general");
        }
        System.out.println(new String(out.toByteArray()));
    }

    public abstract OAIResponder getResponder() throws RepositoryException;

    public static HashMap getAsParameterMap(String[] args) {
        HashMap<String, String> h = new HashMap<String, String>();
        for (String arg : args) {
            int pos = arg.indexOf("=");
            if (pos == -1) continue;
            String name = arg.substring(0, pos);
            String value = arg.substring(pos + 1);
            h.put(name, value);
        }
        return h;
    }
}

