/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.oai;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.fcrepo.common.Constants;
import org.fcrepo.oai.BadArgumentException;
import org.fcrepo.oai.BadVerbException;
import org.fcrepo.oai.DateGranularitySupport;
import org.fcrepo.oai.DeletedRecordSupport;
import org.fcrepo.oai.Header;
import org.fcrepo.oai.MetadataFormat;
import org.fcrepo.oai.NoRecordsMatchException;
import org.fcrepo.oai.OAIException;
import org.fcrepo.oai.OAIProvider;
import org.fcrepo.oai.Record;
import org.fcrepo.oai.RepositoryException;
import org.fcrepo.oai.ResumptionToken;
import org.fcrepo.oai.SetInfo;
import org.fcrepo.server.Context;
import org.fcrepo.server.errors.authorization.AuthzException;
import org.fcrepo.server.security.Authorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAIResponder
implements Constants {
    private static final Logger logger = LoggerFactory.getLogger(OAIResponder.class);
    private final OAIProvider m_provider;
    private DateGranularitySupport m_granularity;
    private final Authorization m_authorization;

    public OAIResponder(OAIProvider provider, Authorization authorization) {
        this.m_provider = provider;
        this.m_authorization = authorization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void respond(Context context, Map args, OutputStream outStream) throws RepositoryException, AuthzException {
        block52: {
            if (this.m_authorization != null) {
                this.m_authorization.enforceOAIRespond(context);
            } else {
                logger.warn("Serving OAIResponses without Authorization module");
            }
            this.m_granularity = this.m_provider.getDateGranularitySupport();
            PrintWriter out = null;
            try {
                out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outStream, "UTF-8")));
            }
            catch (UnsupportedEncodingException uee) {
                // empty catch block
            }
            String verb = (String)args.get("verb");
            String baseURL = this.m_provider.getBaseURL(context.getEnvironmentValue(OAIResponder.HTTP_REQUEST.SECURITY.uri).equals(OAIResponder.HTTP_REQUEST.SECURE.uri) ? "https" : "http", context.getEnvironmentValue(OAIResponder.HTTP_REQUEST.SERVER_PORT.uri));
            try {
                if (verb == null) {
                    throw new BadVerbException("Request did not specify a verb.");
                }
                if (verb.equals("GetRecord")) {
                    String identifier = (String)args.get("identifier");
                    if (identifier == null) {
                        throw new BadArgumentException("GetRecord request did not specify 'identifier' argument.");
                    }
                    String metadataPrefix = (String)args.get("metadataPrefix");
                    if (metadataPrefix == null) {
                        throw new BadArgumentException("GetRecord request did not specify 'metadataPrefix' argument.");
                    }
                    if (args.size() > 3) {
                        throw new BadArgumentException("GetRecord request specified illegal argument(s).");
                    }
                    Record record = this.m_provider.getRecord(identifier, metadataPrefix);
                    this.respondToGetRecord(args, baseURL, record, out);
                    break block52;
                }
                if (verb.equals("Identify")) {
                    if (args.size() > 1) {
                        throw new BadArgumentException("Identify request specified illegal argument(s).");
                    }
                    String repositoryName = this.m_provider.getRepositoryName();
                    String protocolVersion = this.m_provider.getProtocolVersion();
                    Date earliestDatestamp = this.m_provider.getEarliestDatestamp();
                    DeletedRecordSupport deletedRecord = this.m_provider.getDeletedRecordSupport();
                    Set adminEmails = this.m_provider.getAdminEmails();
                    Set compressions = this.m_provider.getSupportedCompressionEncodings();
                    Set descriptions = this.m_provider.getDescriptions();
                    this.respondToIdentify(args, baseURL, repositoryName, protocolVersion, earliestDatestamp, deletedRecord, adminEmails, compressions, descriptions, out);
                    break block52;
                }
                if (verb.equals("ListIdentifiers")) {
                    List headers;
                    String rToken = (String)args.get("resumptionToken");
                    if (rToken != null) {
                        if (args.size() > 2) {
                            throw new BadArgumentException("ListIdentifiers request specified resumptionToken with other arguments.");
                        }
                        headers = this.m_provider.getHeaders(rToken);
                    } else {
                        Iterator iter = args.keySet().iterator();
                        boolean badParam = false;
                        Date from = null;
                        Date until = null;
                        String metadataPrefix = null;
                        String set = null;
                        while (iter.hasNext()) {
                            String name = (String)iter.next();
                            if (name.equals("metadataPrefix")) {
                                metadataPrefix = (String)args.get(name);
                                continue;
                            }
                            if (name.equals("set")) {
                                set = (String)args.get(name);
                                continue;
                            }
                            if (name.equals("from")) {
                                from = this.getUTCDate((String)args.get(name), false);
                                continue;
                            }
                            if (name.equals("until")) {
                                until = this.getUTCDate((String)args.get(name), true);
                                continue;
                            }
                            if (name.equals("verb")) continue;
                            badParam = true;
                        }
                        if (from != null && until != null) {
                            this.assertSameGranularity((String)args.get("from"), (String)args.get("until"));
                        }
                        if (badParam) {
                            throw new BadArgumentException("ListIdentifiers request specified illegal argument(s).");
                        }
                        if (metadataPrefix == null) {
                            throw new BadArgumentException("ListIdentifiers request did not specify metadataPrefix argument.");
                        }
                        headers = this.m_provider.getHeaders(from, until, metadataPrefix, set);
                    }
                    if (headers.size() == 0) {
                        throw new NoRecordsMatchException("No records match the providied criteria.");
                    }
                    ResumptionToken resumptionToken = null;
                    if (this.m_provider.getMaxHeaders() > 0L && (long)headers.size() > this.m_provider.getMaxHeaders()) {
                        resumptionToken = (ResumptionToken)headers.get(headers.size() - 1);
                        headers = headers.subList(0, headers.size() - 1);
                    }
                    this.respondToListIdentifiers(args, baseURL, headers, resumptionToken, out);
                    break block52;
                }
                if (verb.equals("ListMetadataFormats")) {
                    String identifier = (String)args.get("identifier");
                    if (identifier == null ? args.size() > 1 : args.size() > 2) {
                        throw new BadArgumentException("ListMetadataFormats request specified illegal argument(s).");
                    }
                    this.respondToListMetadataFormats(args, baseURL, this.m_provider.getMetadataFormats(identifier), out);
                    break block52;
                }
                if (verb.equals("ListRecords")) {
                    List records;
                    String rToken = (String)args.get("resumptionToken");
                    if (rToken != null) {
                        if (args.size() > 2) {
                            throw new BadArgumentException("ListRecords request specified resumptionToken with other arguments.");
                        }
                        records = this.m_provider.getRecords(rToken);
                    } else {
                        Iterator iter = args.keySet().iterator();
                        boolean badParam = false;
                        Date from = null;
                        Date until = null;
                        String metadataPrefix = null;
                        String set = null;
                        while (iter.hasNext()) {
                            String name = (String)iter.next();
                            if (name.equals("metadataPrefix")) {
                                metadataPrefix = (String)args.get(name);
                                continue;
                            }
                            if (name.equals("set")) {
                                set = (String)args.get(name);
                                continue;
                            }
                            if (name.equals("from")) {
                                from = this.getUTCDate((String)args.get(name), false);
                                continue;
                            }
                            if (name.equals("until")) {
                                until = this.getUTCDate((String)args.get(name), true);
                                continue;
                            }
                            if (name.equals("verb")) continue;
                            badParam = true;
                        }
                        if (from != null && until != null) {
                            this.assertSameGranularity((String)args.get("from"), (String)args.get("until"));
                        }
                        if (badParam) {
                            throw new BadArgumentException("ListRecords request specified illegal argument(s).");
                        }
                        if (metadataPrefix == null) {
                            throw new BadArgumentException("ListRecords request did not specify metadataPrefix argument.");
                        }
                        records = this.m_provider.getRecords(from, until, metadataPrefix, set);
                    }
                    if (records.size() == 0) {
                        throw new NoRecordsMatchException("No records match the providied criteria.");
                    }
                    ResumptionToken resumptionToken = null;
                    if (this.m_provider.getMaxRecords() > 0L && (long)records.size() > this.m_provider.getMaxRecords()) {
                        resumptionToken = (ResumptionToken)records.get(records.size() - 1);
                        records = records.subList(0, records.size() - 1);
                    }
                    this.respondToListRecords(args, baseURL, records, resumptionToken, out);
                    break block52;
                }
                if (verb.equals("ListSets")) {
                    List sets;
                    String rToken = (String)args.get("resumptionToken");
                    if (rToken == null) {
                        if (args.size() > 1) {
                            throw new BadArgumentException("ListSets request specified illegal argument(s).");
                        }
                        sets = this.m_provider.getSets();
                    } else {
                        if (args.size() > 2) {
                            throw new BadArgumentException("ListSets request specified illegal argument(s).");
                        }
                        sets = this.m_provider.getSets(rToken);
                    }
                    ResumptionToken resumptionToken = null;
                    if (this.m_provider.getMaxSets() > 0L && (long)sets.size() > this.m_provider.getMaxSets()) {
                        resumptionToken = (ResumptionToken)sets.get(sets.size() - 1);
                        sets = sets.subList(0, sets.size() - 1);
                    }
                    this.respondToListSets(args, baseURL, sets, resumptionToken, out);
                    break block52;
                }
                throw new BadVerbException("Unrecognized verb, '" + verb + "'.");
            }
            catch (OAIException oaie) {
                this.respondWithError(oaie, verb, baseURL, out);
            }
            finally {
                out.flush();
            }
        }
    }

    private void assertSameGranularity(String from, String until) throws BadArgumentException {
        if (from.endsWith("Z") && !until.endsWith("Z") || until.endsWith("Z") && !from.endsWith("Z")) {
            throw new BadArgumentException("Date granularities of from and until arguments do not match.");
        }
    }

    private void respondToGetRecord(Map args, String baseURL, Record record, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <GetRecord>");
        this.appendRecord("    ", record, out);
        out.println("  </GetRecord>");
        this.appendBottom(out);
    }

    private void respondToIdentify(Map args, String baseURL, String repositoryName, String protocolVersion, Date earliestDatestamp, DeletedRecordSupport deletedRecord, Set adminEmails, Set compressions, Set descriptions, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <Identify>");
        out.println("    <repositoryName>" + OAIResponder.enc(repositoryName) + "</repositoryName>");
        out.println("    <baseURL>" + OAIResponder.enc(baseURL) + "</baseURL>");
        out.println("    <protocolVersion>" + protocolVersion + "</protocolVersion>");
        Iterator iter = adminEmails.iterator();
        while (iter.hasNext()) {
            out.println("    <adminEmail>" + OAIResponder.enc((String)iter.next()) + "</adminEmail>");
        }
        out.println("    <earliestDatestamp>" + OAIResponder.getUTCString(earliestDatestamp, this.m_granularity == DateGranularitySupport.SECONDS) + "</earliestDatestamp>");
        out.println("    <deletedRecord>" + deletedRecord.toString() + "</deletedRecord>");
        out.println("    <granularity>" + this.m_granularity.toString() + "</granularity>");
        iter = compressions.iterator();
        while (iter.hasNext()) {
            out.println("    <compression>" + OAIResponder.enc((String)iter.next()) + "</compression>");
        }
        iter = descriptions.iterator();
        while (iter.hasNext()) {
            out.println("    <description>");
            out.println((String)iter.next());
            out.println("    </description>");
        }
        out.println("  </Identify>");
        this.appendBottom(out);
    }

    private void respondToListIdentifiers(Map args, String baseURL, List headers, ResumptionToken resumptionToken, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <ListIdentifiers>");
        for (int i = 0; i < headers.size(); ++i) {
            Header header = (Header)headers.get(i);
            this.appendHeader("    ", header, out);
        }
        this.appendResumptionToken(resumptionToken, out);
        out.println("  </ListIdentifiers>");
        this.appendBottom(out);
    }

    private void respondToListMetadataFormats(Map args, String baseURL, Set metadataFormats, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <ListMetadataFormats>");
        for (MetadataFormat f : metadataFormats) {
            out.println("    <metadataFormat>");
            out.println("      <metadataPrefix>" + f.getPrefix() + "</metadataPrefix>");
            out.println("      <schema>" + f.getSchemaLocation() + "</schema>");
            out.println("      <metadataNamespace>" + f.getNamespaceURI() + "</metadataNamespace>");
            out.println("    </metadataFormat>");
        }
        out.println("  </ListMetadataFormats>");
        this.appendBottom(out);
    }

    private void respondToListRecords(Map args, String baseURL, List records, ResumptionToken resumptionToken, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <ListRecords>");
        for (int i = 0; i < records.size(); ++i) {
            this.appendRecord("    ", (Record)records.get(i), out);
        }
        this.appendResumptionToken(resumptionToken, out);
        out.println("  </ListRecords>");
        this.appendBottom(out);
    }

    private void respondToListSets(Map args, String baseURL, List sets, ResumptionToken resumptionToken, PrintWriter out) {
        this.appendTop(out);
        this.appendRequest(args, baseURL, out);
        out.println("  <ListSets>");
        for (int i = 0; i < sets.size(); ++i) {
            SetInfo s = (SetInfo)sets.get(i);
            out.println("    <set>");
            out.println("      <setSpec>" + s.getSpec() + "</setSpec>");
            out.println("      <setName>" + s.getName() + "</setName>");
            Iterator iter = s.getDescriptions().iterator();
            while (iter.hasNext()) {
                out.println("      <setDescription>\n");
                out.println((String)iter.next());
                out.println("      </setDescription>\n");
            }
            out.println("    </set>");
        }
        this.appendResumptionToken(resumptionToken, out);
        out.println("  </ListSets>");
        this.appendBottom(out);
    }

    private void appendRecord(String indent, Record record, PrintWriter out) {
        Header header = record.getHeader();
        String metadata = record.getMetadata();
        Set abouts = record.getAbouts();
        out.println(indent + "<record>");
        this.appendHeader(indent + "  ", header, out);
        if (header.isAvailable()) {
            out.println(indent + "  <metadata>");
            out.println(metadata);
            out.println(indent + "  </metadata>");
            Iterator iter = abouts.iterator();
            while (iter.hasNext()) {
                out.println(indent + "  <about>");
                out.println((String)iter.next());
                out.println(indent + "  </about>");
            }
        }
        out.println(indent + "</record>");
    }

    private void appendHeader(String indent, Header header, PrintWriter out) {
        String identifier = header.getIdentifier();
        Date datestamp = header.getDatestamp();
        Set setSpecs = header.getSetSpecs();
        boolean isAvailable = header.isAvailable();
        out.print(indent + "<header");
        if (!isAvailable) {
            out.print(" status=\"deleted\"");
        }
        out.println(">");
        out.println(indent + "  <identifier>" + OAIResponder.enc(identifier) + "</identifier>");
        out.println(indent + "  <datestamp>" + OAIResponder.getUTCString(datestamp, this.m_granularity == DateGranularitySupport.SECONDS) + "</datestamp>");
        Iterator iter = setSpecs.iterator();
        while (iter.hasNext()) {
            out.println(indent + "  <setSpec>" + OAIResponder.enc((String)iter.next()) + "</setSpec>");
        }
        out.println(indent + "</header>");
    }

    private void appendResumptionToken(ResumptionToken token, PrintWriter out) {
        if (token != null) {
            out.print("    <resumptionToken");
            if (token.getExpirationDate() != null) {
                out.print(" expirationDate=\"" + OAIResponder.getUTCString(token.getExpirationDate(), true) + "\"");
            }
            if (token.getCompleteListSize() >= 0L) {
                out.print(" completeListSize=\"" + token.getCompleteListSize() + "\"");
            }
            if (token.getCursor() >= 0L) {
                out.print(" cursor=\"" + token.getCursor() + "\"");
            }
            if (token.getValue() != null) {
                out.println(">" + token.getValue() + "</resumptionToken>");
            } else {
                out.println("/>");
            }
        }
    }

    private void appendRequest(Map args, String baseURL, PrintWriter out) {
        out.print("  <request");
        for (String name : args.keySet()) {
            String value = (String)args.get(name);
            out.print(" " + name + "=\"" + OAIResponder.enc(value) + "\"");
        }
        out.println(">" + OAIResponder.enc(baseURL) + "</request>");
    }

    private void appendTop(PrintWriter out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<OAI-PMH xmlns=\"" + OAIResponder.OAI_PMH.uri + "\"");
        out.println("         xmlns:xsi=\"" + OAIResponder.XSI.uri + "\"");
        out.println("         xsi:schemaLocation=\"" + OAIResponder.OAI_PMH.uri + " " + OAIResponder.OAI_PMH2_0.xsdLocation + "\">");
        out.println("  <responseDate>" + OAIResponder.getUTCString(this.getUTCDate(new Date()), true) + "</responseDate>");
    }

    private void appendBottom(PrintWriter out) {
        out.println("</OAI-PMH>");
    }

    private void respondWithError(OAIException e, String verb, String baseURL, PrintWriter out) {
        this.appendTop(out);
        out.print("  <request");
        if (!e.getCode().equals("badVerb")) {
            out.print(" verb=\"" + verb + "\"");
        }
        out.println(">" + OAIResponder.enc(baseURL) + "</request>");
        if (e.getMessage() == null) {
            out.println("  <error code=\"" + e.getCode() + "\"/>");
        } else {
            out.println("  <error code=\"" + e.getCode() + "\">" + OAIResponder.enc(e.getMessage()) + "</error>");
        }
        this.appendBottom(out);
    }

    private static String getUTCString(Date utcDate, boolean fineGranularity) {
        SimpleDateFormat formatter = fineGranularity ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'") : new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(utcDate);
    }

    private Date getUTCDate(String formattedDate, boolean isUntil) throws BadArgumentException {
        if (formattedDate == null) {
            return null;
        }
        try {
            if (formattedDate.endsWith("Z")) {
                if (this.m_granularity == DateGranularitySupport.SECONDS) {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                    return formatter.parse(formattedDate);
                }
                throw new BadArgumentException("Repository does not support that granularity.");
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            if (isUntil) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return sdf.parse(formatter.format(formatter.parse(formattedDate)) + "T23:59:59Z");
            }
            return formatter.parse(formattedDate);
        }
        catch (ParseException pe) {
            throw new BadArgumentException("Error parsing date.");
        }
    }

    private Date getUTCDate(Date localDate) {
        Calendar cal = Calendar.getInstance();
        int tzOffset = cal.get(15);
        TimeZone tz = cal.getTimeZone();
        if (tz.inDaylightTime(localDate)) {
            tzOffset += cal.get(16);
        }
        Date UTCDate = new Date();
        UTCDate.setTime(localDate.getTime() + (long)tzOffset);
        return UTCDate;
    }

    private static String enc(String in) {
        StringBuffer out = new StringBuffer();
        OAIResponder.enc(in, out);
        return out.toString();
    }

    private static void enc(String in, StringBuffer out) {
        for (int i = 0; i < in.length(); ++i) {
            OAIResponder.enc(in.charAt(i), out);
        }
    }

    private static void enc(char[] in, int start, int length, StringBuffer out) {
        for (int i = start; i < length + start; ++i) {
            OAIResponder.enc(in[i], out);
        }
    }

    private static void enc(char in, StringBuffer out) {
        if (in == '&') {
            out.append("&amp;");
        } else if (in == '<') {
            out.append("&lt;");
        } else if (in == '>') {
            out.append("&gt;");
        } else if (in == '\"') {
            out.append("&quot;");
        } else if (in == '\'') {
            out.append("&apos;");
        } else {
            out.append(in);
        }
    }
}

